/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.StateType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeGlobalId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.bidirassocproperties.Bidirectional;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pparamsconfig.HierarchicalLinkId;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of config.
 */
public interface Config extends Augmentable  {

    /**
     * Identify the leaf of Config.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents type.
         */
        TYPE(2),
        /**
         * Represents identifier.
         */
        IDENTIFIER(3),
        /**
         * Represents description.
         */
        DESCRIPTION(4),
        /**
         * Represents switchingLayer.
         */
        SWITCHINGLAYER(5),
        /**
         * Represents encoding.
         */
        ENCODING(6),
        /**
         * Represents protectionType.
         */
        PROTECTIONTYPE(7),
        /**
         * Represents adminStatus.
         */
        ADMINSTATUS(8),
        /**
         * Represents preference.
         */
        PREFERENCE(9),
        /**
         * Represents reoptimizeTimer.
         */
        REOPTIMIZETIMER(10),
        /**
         * Represents providerId.
         */
        PROVIDERID(11),
        /**
         * Represents clientId.
         */
        CLIENTID(12),
        /**
         * Represents teTopologyId.
         */
        TETOPOLOGYID(13),
        /**
         * Represents source.
         */
        SOURCE(14),
        /**
         * Represents destination.
         */
        DESTINATION(15),
        /**
         * Represents srcTpId.
         */
        SRCTPID(16),
        /**
         * Represents dstTpId.
         */
        DSTTPID(17),
        /**
         * Represents setupPriority.
         */
        SETUPPRIORITY(18),
        /**
         * Represents holdPriority.
         */
        HOLDPRIORITY(19),
        /**
         * Represents signalingType.
         */
        SIGNALINGTYPE(20);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends TunnelType> type();

    /**
     * Returns the attribute identifier.
     *
     * @return identifier value of identifier
     */
    int identifier();

    /**
     * Returns the attribute description.
     *
     * @return description value of description
     */
    String description();

    /**
     * Returns the attribute switchingLayer.
     *
     * @return switchingLayer value of switchingLayer
     */
    Class<? extends SwitchingCapabilities> switchingLayer();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Class<? extends LspEncodingTypes> encoding();

    /**
     * Returns the attribute protectionType.
     *
     * @return protectionType value of protectionType
     */
    Class<? extends LspProtType> protectionType();

    /**
     * Returns the attribute adminStatus.
     *
     * @return adminStatus value of adminStatus
     */
    Class<? extends StateType> adminStatus();

    /**
     * Returns the attribute preference.
     *
     * @return preference value of preference
     */
    short preference();

    /**
     * Returns the attribute reoptimizeTimer.
     *
     * @return reoptimizeTimer value of reoptimizeTimer
     */
    int reoptimizeTimer();

    /**
     * Returns the attribute providerId.
     *
     * @return providerId value of providerId
     */
    TeGlobalId providerId();

    /**
     * Returns the attribute clientId.
     *
     * @return clientId value of clientId
     */
    TeGlobalId clientId();

    /**
     * Returns the attribute teTopologyId.
     *
     * @return teTopologyId value of teTopologyId
     */
    TeTopologyId teTopologyId();

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    IpAddress source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    IpAddress destination();

    /**
     * Returns the attribute srcTpId.
     *
     * @return srcTpId value of srcTpId
     */
    byte[] srcTpId();

    /**
     * Returns the attribute dstTpId.
     *
     * @return dstTpId value of dstTpId
     */
    byte[] dstTpId();

    /**
     * Returns the attribute setupPriority.
     *
     * @return setupPriority value of setupPriority
     */
    short setupPriority();

    /**
     * Returns the attribute holdPriority.
     *
     * @return holdPriority value of holdPriority
     */
    short holdPriority();

    /**
     * Returns the attribute signalingType.
     *
     * @return signalingType value of signalingType
     */
    Class<? extends TunnelType> signalingType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute hierarchicalLinkId.
     *
     * @return hierarchicalLinkId value of hierarchicalLinkId
     */
    HierarchicalLinkId hierarchicalLinkId();

    /**
     * Returns the attribute bidirectional.
     *
     * @return bidirectional value of bidirectional
     */
    Bidirectional bidirectional();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends TunnelType> type);

    /**
     * Sets the attribute identifier.
     *
     * @param identifier value of identifier
     */
    void identifier(int identifier);

    /**
     * Sets the attribute description.
     *
     * @param description value of description
     */
    void description(String description);

    /**
     * Sets the attribute switchingLayer.
     *
     * @param switchingLayer value of switchingLayer
     */
    void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Class<? extends LspEncodingTypes> encoding);

    /**
     * Sets the attribute protectionType.
     *
     * @param protectionType value of protectionType
     */
    void protectionType(Class<? extends LspProtType> protectionType);

    /**
     * Sets the attribute adminStatus.
     *
     * @param adminStatus value of adminStatus
     */
    void adminStatus(Class<? extends StateType> adminStatus);

    /**
     * Sets the attribute preference.
     *
     * @param preference value of preference
     */
    void preference(short preference);

    /**
     * Sets the attribute reoptimizeTimer.
     *
     * @param reoptimizeTimer value of reoptimizeTimer
     */
    void reoptimizeTimer(int reoptimizeTimer);

    /**
     * Sets the attribute providerId.
     *
     * @param providerId value of providerId
     */
    void providerId(TeGlobalId providerId);

    /**
     * Sets the attribute clientId.
     *
     * @param clientId value of clientId
     */
    void clientId(TeGlobalId clientId);

    /**
     * Sets the attribute teTopologyId.
     *
     * @param teTopologyId value of teTopologyId
     */
    void teTopologyId(TeTopologyId teTopologyId);

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(IpAddress source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(IpAddress destination);

    /**
     * Sets the attribute srcTpId.
     *
     * @param srcTpId value of srcTpId
     */
    void srcTpId(byte[] srcTpId);

    /**
     * Sets the attribute dstTpId.
     *
     * @param dstTpId value of dstTpId
     */
    void dstTpId(byte[] dstTpId);

    /**
     * Sets the attribute setupPriority.
     *
     * @param setupPriority value of setupPriority
     */
    void setupPriority(short setupPriority);

    /**
     * Sets the attribute holdPriority.
     *
     * @param holdPriority value of holdPriority
     */
    void holdPriority(short holdPriority);

    /**
     * Sets the attribute signalingType.
     *
     * @param signalingType value of signalingType
     */
    void signalingType(Class<? extends TunnelType> signalingType);

    /**
     * Sets the attribute hierarchicalLinkId.
     *
     * @param hierarchicalLinkId value of hierarchicalLinkId
     */
    void hierarchicalLinkId(HierarchicalLinkId hierarchicalLinkId);

    /**
     * Sets the attribute bidirectional.
     *
     * @param bidirectional value of bidirectional
     */
    void bidirectional(Bidirectional bidirectional);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}