/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of candidateP2PsecondaryPath.
 */
public class CandidateP2PsecondaryPathKeys implements KeyInfo<DefaultCandidateP2PsecondaryPath> {
    protected Object secondaryPath;
    /**
     * Returns the attribute secondaryPath.
     *
     * @return secondaryPath value of secondaryPath
     */
    public Object secondaryPath() {
        return secondaryPath;
    }

    /**
     * Sets the value to attribute secondaryPath.
     *
     * @param secondaryPath value of secondaryPath
     */
    public void secondaryPath(Object secondaryPath) {
        this.secondaryPath = secondaryPath;
    }


    @Override
    public int hashCode() {
        return Objects.hash(secondaryPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CandidateP2PsecondaryPathKeys) {
            CandidateP2PsecondaryPathKeys other = (CandidateP2PsecondaryPathKeys) obj;
            return
                Objects.deepEquals(secondaryPath, other.secondaryPath);
        }
        return false;
    }
}