/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.candidatep2psecondarypath;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathSetupProtocol;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of config.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConfig extends InnerModelObject implements Config {
    protected Object secondaryPath;
    protected int priority;
    protected Class<? extends TePathSetupProtocol> pathSetupProtocol;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Object secondaryPath() {
        return secondaryPath;
    }

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public Class<? extends TePathSetupProtocol> pathSetupProtocol() {
        return pathSetupProtocol;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void secondaryPath(Object secondaryPath) {
        valueLeafFlags.set(LeafIdentifier.SECONDARYPATH.getLeafIndex());
        this.secondaryPath = secondaryPath;
    }

    @Override
    public void priority(int priority) {
        valueLeafFlags.set(LeafIdentifier.PRIORITY.getLeafIndex());
        this.priority = priority;
    }

    @Override
    public void pathSetupProtocol(Class<? extends TePathSetupProtocol> pathSetupProtocol) {
        valueLeafFlags.set(LeafIdentifier.PATHSETUPPROTOCOL.getLeafIndex());
        this.pathSetupProtocol = pathSetupProtocol;
    }

    @Override
    public int hashCode() {
        return Objects.hash(secondaryPath, priority, pathSetupProtocol, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConfig) {
            DefaultConfig other = (DefaultConfig) obj;
            return
                Objects.deepEquals(secondaryPath, other.secondaryPath) &&
                Objects.deepEquals(priority, other.priority) &&
                Objects.deepEquals(pathSetupProtocol, other.pathSetupProtocol) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("secondaryPath=" + secondaryPath)
            .add("priority=" + priority)
            .add("pathSetupProtocol=" + pathSetupProtocol)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultConfig.
     */
    public DefaultConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}