/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.Bandwidth;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.P2PprimaryPaths;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.P2PsecondaryPaths;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.State;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of tunnel.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTunnel extends InnerModelObject 
        implements Tunnel, MultiInstanceObject<TunnelKeys> {
    protected Object name;
    protected Object identifier;
    protected BitSet valueLeafFlags = new BitSet();
    protected Config config;
    protected State state;
    protected P2PprimaryPaths p2PprimaryPaths;
    protected P2PsecondaryPaths p2PsecondaryPaths;
    protected Bandwidth bandwidth;

    @Override
    public Object name() {
        return name;
    }

    @Override
    public Object identifier() {
        return identifier;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public P2PprimaryPaths p2PprimaryPaths() {
        return p2PprimaryPaths;
    }

    @Override
    public P2PsecondaryPaths p2PsecondaryPaths() {
        return p2PsecondaryPaths;
    }

    @Override
    public Bandwidth bandwidth() {
        return bandwidth;
    }

    @Override
    public void name(Object name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void identifier(Object identifier) {
        valueLeafFlags.set(LeafIdentifier.IDENTIFIER.getLeafIndex());
        this.identifier = identifier;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public void p2PprimaryPaths(P2PprimaryPaths p2PprimaryPaths) {
        this.p2PprimaryPaths = p2PprimaryPaths;
    }

    @Override
    public void p2PsecondaryPaths(P2PsecondaryPaths p2PsecondaryPaths) {
        this.p2PsecondaryPaths = p2PsecondaryPaths;
    }

    @Override
    public void bandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, identifier, valueLeafFlags, config, state, p2PprimaryPaths, p2PsecondaryPaths, bandwidth);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTunnel) {
            DefaultTunnel other = (DefaultTunnel) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(identifier, other.identifier) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(config, other.config) &&
                Objects.deepEquals(state, other.state) &&
                Objects.deepEquals(p2PprimaryPaths, other.p2PprimaryPaths) &&
                Objects.deepEquals(p2PsecondaryPaths, other.p2PsecondaryPaths) &&
                Objects.deepEquals(bandwidth, other.bandwidth);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("identifier=" + identifier)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("config=" + config)
            .add("state=" + state)
            .add("p2PprimaryPaths=" + p2PprimaryPaths)
            .add("p2PsecondaryPaths=" + p2PsecondaryPaths)
            .add("bandwidth=" + bandwidth)
            .toString();
    }


    /**
     * Creates an instance of defaultTunnel.
     */
    public DefaultTunnel() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}