/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.anytest.rev20160624;

import org.onosproject.yang.gen.v11.anytest.rev20160624.anytest.C1;
import org.onosproject.yang.gen.v11.anytest.rev20160624.anytest.Mydata;

/**
 * Abstraction of an entity which represents the functionality of anyTest.
 */
public interface AnyTest {

    /**
     * Returns the attribute mydata.
     *
     * @return mydata value of mydata
     */
    Mydata mydata();

    /**
     * Returns the attribute c1.
     *
     * @return c1 value of c1
     */
    C1 c1();

    /**
     * Sets the attribute mydata.
     *
     * @param mydata value of mydata
     */
    void mydata(Mydata mydata);

    /**
     * Sets the attribute c1.
     *
     * @param c1 value of c1
     */
    void c1(C1 c1);

}