/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.Request;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of otnTeTunnelPathComputeInput.
 */
public class DefaultOtnTeTunnelPathComputeInput extends InnerModelObject implements OtnTeTunnelPathComputeInput {
    protected List<Request> request;

    @Override
    public List<Request> request() {
        return request;
    }

    @Override
    public void request(List<Request> request) {
        this.request = request;
    }

    @Override
    public void addToRequest(Request addTo) {
        if (request == null) {
            request = new ArrayList<>();
        }
        request.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(request);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultOtnTeTunnelPathComputeInput) {
            DefaultOtnTeTunnelPathComputeInput other = (DefaultOtnTeTunnelPathComputeInput) obj;
            return
                Objects.deepEquals(request, other.request);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("request=" + request)
            .toString();
    }


    /**
     * Creates an instance of defaultOtnTeTunnelPathComputeInput.
     */
    public DefaultOtnTeTunnelPathComputeInput() {
    }

}