/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.errors.errors.error;

/**
 * Represents ENUM data of errorTypeEnum.
 */
public enum ErrorTypeEnum {

    /**
     * Represents transport.
     */
    TRANSPORT(0, "transport"),

    /**
     * Represents rpc.
     */
    RPC(1, "rpc"),

    /**
     * Represents protocol.
     */
    PROTOCOL(2, "protocol"),

    /**
     * Represents application.
     */
    APPLICATION(3, "application");

    private int errorTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of errorTypeEnum.
     *
     * @param errorTypeEnum value of errorTypeEnum
     */
     ErrorTypeEnum(int errorTypeEnum, String schemaName) {
        this.errorTypeEnum = errorTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of errorTypeEnum for.
     *
     * @param value value of errorTypeEnum for
     * @return errorTypeEnum for
     */
    public static ErrorTypeEnum of(int value) {
        switch (value) {
            case 0:
                return ErrorTypeEnum.TRANSPORT;
            case 1:
                return ErrorTypeEnum.RPC;
            case 2:
                return ErrorTypeEnum.PROTOCOL;
            case 3:
                return ErrorTypeEnum.APPLICATION;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of errorTypeEnum for.
     *
     * @param value value of errorTypeEnum for
     * @return errorTypeEnum for
     */
    public static ErrorTypeEnum of(String value) {
        switch (value) {
            case "transport":
                return ErrorTypeEnum.TRANSPORT;
            case "rpc":
                return ErrorTypeEnum.RPC;
            case "protocol":
                return ErrorTypeEnum.PROTOCOL;
            case "application":
                return ErrorTypeEnum.APPLICATION;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute errorTypeEnum.
     *
     * @return errorTypeEnum value of errorTypeEnum
     */
    public int errorTypeEnum() {
        return errorTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
