/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.restconf;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.restconf.restconf.Data;
import org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.restconf.restconf.Operations;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of restconf.
 */
public interface Restconf extends Augmentable  {

    /**
     * Identify the leaf of Restconf.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents yangLibraryVersion.
         */
        YANGLIBRARYVERSION(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute yangLibraryVersion.
     *
     * @return yangLibraryVersion value of yangLibraryVersion
     */
    String yangLibraryVersion();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute data.
     *
     * @return data value of data
     */
    Data data();

    /**
     * Returns the attribute operations.
     *
     * @return operations value of operations
     */
    Operations operations();

    /**
     * Sets the attribute yangLibraryVersion.
     *
     * @param yangLibraryVersion value of yangLibraryVersion
     */
    void yangLibraryVersion(String yangLibraryVersion);

    /**
     * Sets the attribute data.
     *
     * @param data value of data
     */
    void data(Data data);

    /**
     * Sets the attribute operations.
     *
     * @param operations value of operations
     */
    void operations(Operations operations);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}