/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of edit.
 */
public class EditKeys implements KeyInfo<DefaultEdit> {
    protected String editId;
    /**
     * Returns the attribute editId.
     *
     * @return editId value of editId
     */
    public String editId() {
        return editId;
    }

    /**
     * Sets the value to attribute editId.
     *
     * @param editId value of editId
     */
    public void editId(String editId) {
        this.editId = editId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(editId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EditKeys) {
            EditKeys other = (EditKeys) obj;
            return
                Objects.deepEquals(editId, other.editId);
        }
        return false;
    }
}