/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit;

/**
 * Represents ENUM data of operationEnum.
 */
public enum OperationEnum {

    /**
     * Represents create.
     */
    CREATE(0, "create"),

    /**
     * Represents delete.
     */
    DELETE(1, "delete"),

    /**
     * Represents insert.
     */
    INSERT(2, "insert"),

    /**
     * Represents merge.
     */
    MERGE(3, "merge"),

    /**
     * Represents move.
     */
    MOVE(4, "move"),

    /**
     * Represents replace.
     */
    REPLACE(5, "replace"),

    /**
     * Represents remove.
     */
    REMOVE(6, "remove");

    private int operationEnum;
    private String schemaName;

    /**
     * Creates an instance of operationEnum.
     *
     * @param operationEnum value of operationEnum
     */
     OperationEnum(int operationEnum, String schemaName) {
        this.operationEnum = operationEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of operationEnum for.
     *
     * @param value value of operationEnum for
     * @return operationEnum for
     */
    public static OperationEnum of(int value) {
        switch (value) {
            case 0:
                return OperationEnum.CREATE;
            case 1:
                return OperationEnum.DELETE;
            case 2:
                return OperationEnum.INSERT;
            case 3:
                return OperationEnum.MERGE;
            case 4:
                return OperationEnum.MOVE;
            case 5:
                return OperationEnum.REPLACE;
            case 6:
                return OperationEnum.REMOVE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of operationEnum for.
     *
     * @param value value of operationEnum for
     * @return operationEnum for
     */
    public static OperationEnum of(String value) {
        switch (value) {
            case "create":
                return OperationEnum.CREATE;
            case "delete":
                return OperationEnum.DELETE;
            case "insert":
                return OperationEnum.INSERT;
            case "merge":
                return OperationEnum.MERGE;
            case "move":
                return OperationEnum.MOVE;
            case "replace":
                return OperationEnum.REPLACE;
            case "remove":
                return OperationEnum.REMOVE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute operationEnum.
     *
     * @return operationEnum value of operationEnum
     */
    public int operationEnum() {
        return operationEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
