/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.editstatus.Edit;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of editStatus.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultEditStatus extends InnerModelObject implements EditStatus {
    protected List<Edit> edit;

    @Override
    public List<Edit> edit() {
        return edit;
    }

    @Override
    public void edit(List<Edit> edit) {
        this.edit = edit;
    }

    @Override
    public void addToEdit(Edit addTo) {
        if (edit == null) {
            edit = new ArrayList<>();
        }
        edit.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(edit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEditStatus) {
            DefaultEditStatus other = (DefaultEditStatus) obj;
            return
                Objects.deepEquals(edit, other.edit);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("edit=" + edit)
            .toString();
    }


    /**
     * Creates an instance of defaultEditStatus.
     */
    public DefaultEditStatus() {
    }

}