/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils;

import java.util.List;
import java.util.Stack;
import org.onosproject.yang.compiler.datamodel.YangBase;
import org.onosproject.yang.compiler.datamodel.YangIdentity;

public class IdentityHandler {
    private Stack<YangIdentity> stack = new Stack();

    public IdentityHandler(YangBase base) {
        YangIdentity id = base.getParentIdentity();
        if (id.isAddedToAllParent()) {
            return;
        }
        this.stack.push(id);
        this.addToExtendList();
    }

    public void addToExtendList() {
        while (!this.stack.empty()) {
            YangIdentity baseId = this.stack.peek();
            List<YangIdentity> exList = baseId.getExtendList();
            if (exList != null && !exList.isEmpty()) {
                for (YangIdentity id : exList) {
                    if (id.isAddedToAllParent()) continue;
                    this.stack.push(id);
                }
            }
            YangIdentity resolvingId = this.stack.pop();
            this.addToAllParent(resolvingId, resolvingId.getBaseNode().getReferredIdentity());
        }
    }

    private void addToAllParent(YangIdentity referredId, YangIdentity baseId) {
        YangIdentity baseIdentity = baseId;
        while (baseIdentity != null) {
            List<YangIdentity> list = baseIdentity.getExtendList();
            if (!list.contains(referredId)) {
                baseIdentity.addToExtendList(referredId);
            }
            YangBase base = baseIdentity.getBaseNode();
            baseIdentity = null;
            if (base == null) continue;
            baseIdentity = base.getReferredIdentity();
        }
        referredId.setAddedToAllParent(true);
    }
}

