/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.onosproject.yang.compiler.api.YangCompilationParam;
import org.onosproject.yang.compiler.api.YangCompiledOutput;
import org.onosproject.yang.compiler.api.YangCompilerException;
import org.onosproject.yang.compiler.api.YangCompilerService;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.YangDeviationHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.linker.YangLinker;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.YangLinkerManager;
import org.onosproject.yang.compiler.linker.impl.YangLinkerUtils;
import org.onosproject.yang.compiler.parser.YangUtilsParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.YangUtilsParserManager;
import org.onosproject.yang.compiler.tool.DefaultYangCompiledOutput;
import org.onosproject.yang.compiler.tool.YangFileInfo;
import org.onosproject.yang.compiler.tool.YangModuleExtendedInfo;
import org.onosproject.yang.compiler.tool.YangNodeInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.YangFileScanner;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.DefaultYangModel;
import org.onosproject.yang.model.DefaultYangModuleId;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangCompilerManager
implements YangCompilerService {
    private static final Logger log = LoggerFactory.getLogger(YangCompilerManager.class);
    private static final String SLASH = File.separator;
    private final YangUtilsParser yangUtilsParser = new YangUtilsParserManager();
    private final YangLinker yangLinker = new YangLinkerManager();
    private final Set<YangNode> yangNodeSet = new HashSet<YangNode>();
    private Set<YangFileInfo> yangFileInfoSet;
    private YangFileInfo curYangFileInfo = new YangFileInfo();
    private Set<Path> genJavaPath = new LinkedHashSet<Path>();
    private YangModel model;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YangCompiledOutput compileYangFiles(YangCompilationParam param) throws IOException, YangCompilerException {
        Class<YangCompilerManager> clazz = YangCompilerManager.class;
        synchronized (YangCompilerManager.class) {
            this.processYangFiles(param);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new DefaultYangCompiledOutput(this.model, this.genJavaPath);
        }
    }

    public Set<YangNode> getYangNodeSet() {
        return this.yangNodeSet;
    }

    public Set<YangFileInfo> createYangFileInfoSet(Set<Path> yangFileList) {
        if (this.yangFileInfoSet == null) {
            this.yangFileInfoSet = new HashSet<YangFileInfo>();
        }
        for (Path yangFile : yangFileList) {
            YangFileInfo yangFileInfo = new YangFileInfo();
            yangFileInfo.setYangFileName(yangFile.toString());
            this.yangFileInfoSet.add(yangFileInfo);
        }
        return this.yangFileInfoSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processYangFiles(YangCompilationParam param) throws IOException {
        YangPluginConfig config = new YangPluginConfig();
        Class<YangCompilerManager> clazz = YangCompilerManager.class;
        synchronized (YangCompilerManager.class) {
            try {
                String codeGenDir = param.getCodeGenDir() + SLASH;
                String resourceGenDir = param.getMetadataGenDir() + SLASH;
                config.setCodeGenDir(codeGenDir);
                config.resourceGenDir(resourceGenDir);
                this.yangFileInfoSet = this.createYangFileInfoSet(param.getYangFiles());
                if (this.yangFileInfoSet.isEmpty()) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                YangIoUtils.createDirectories(resourceGenDir);
                this.addSchemaToFileSet(this.dependentSchema(param.getDependentSchemas()));
                this.parseYangFileInfoSet();
                this.createYangNodeSet();
                this.processSerialization(resourceGenDir, param.getModelId());
                this.resolveDependenciesUsingLinker();
                this.translateToJava(config);
                this.processGeneratedCode(codeGenDir);
                this.processCopyYangFile(resourceGenDir);
            }
            catch (IOException | ParserException e) {
                YangCompilerException exception = new YangCompilerException(e.getMessage(), (Throwable)e);
                exception.setYangFile(Paths.get(this.curYangFileInfo.getYangFileName(), new String[0]));
                if (this.curYangFileInfo != null && this.curYangFileInfo.getRootNode() != null) {
                    try {
                        JavaCodeGeneratorUtil.translatorErrorHandler(this.curYangFileInfo.getRootNode(), config);
                    }
                    catch (IOException ex) {
                        e.printStackTrace();
                        throw ex;
                    }
                }
                throw exception;
            }
            return;
        }
    }

    private void processGeneratedCode(String codeGenDir) throws IOException {
        List<String> files = YangFileScanner.getJavaFiles(codeGenDir);
        for (String file : files) {
            this.genJavaPath.add(Paths.get(file, new String[0]));
        }
    }

    private Set<YangNode> dependentSchema(Set<Path> dependentSchemaPath) {
        LinkedHashSet<YangNode> depNodes = new LinkedHashSet<YangNode>();
        for (Path path : dependentSchemaPath) {
            try {
                depNodes.addAll(YangCompilerManager.getYangNodes(YangCompilerManager.deSerializeDataModel(path.toString())));
            }
            catch (IOException e) {
                throw new YangCompilerException("Failed to fetch dependent schema from given path :" + path.toString(), (Throwable)e);
            }
        }
        return depNodes;
    }

    private void addSchemaToFileSet(Set<YangNode> dependentSchema) {
        if (dependentSchema == null || dependentSchema.isEmpty()) {
            return;
        }
        for (YangNode node : dependentSchema) {
            YangFileInfo dependentFileInfo = new YangFileInfo();
            node.setToTranslate(false);
            dependentFileInfo.setRootNode(node);
            dependentFileInfo.setForTranslator(false);
            dependentFileInfo.setYangFileName(node.getName());
            dependentFileInfo.setInterJar(true);
            this.yangFileInfoSet.add(dependentFileInfo);
        }
    }

    public void resolveDependenciesUsingLinker() {
        try {
            this.yangLinker.resolveDependencies(this.yangNodeSet);
        }
        catch (LinkerException e) {
            this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
            throw new YangCompilerException(e.getMessage(), (Throwable)e);
        }
    }

    public void createYangNodeSet() {
        for (YangFileInfo yangFileInfo : this.yangFileInfoSet) {
            this.yangNodeSet.add(yangFileInfo.getRootNode());
        }
    }

    public void parseYangFileInfoSet() throws IOException {
        Iterator<YangFileInfo> iterator = this.yangFileInfoSet.iterator();
        while (iterator.hasNext()) {
            YangFileInfo yangFileInfo;
            this.curYangFileInfo = yangFileInfo = iterator.next();
            if (!yangFileInfo.isForTranslator()) continue;
            try {
                YangNode yangNode = this.yangUtilsParser.getDataModel(yangFileInfo.getYangFileName());
                yangFileInfo.setRootNode(yangNode);
                YangLinkerUtils.resolveGroupingInDefinationScope((YangReferenceResolver)((Object)yangNode));
                try {
                    ((YangReferenceResolver)((Object)yangNode)).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                    ((YangReferenceResolver)((Object)yangNode)).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
                }
                catch (DataModelException e) {
                    this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                }
            }
            catch (ParserException e) {
                this.printLog(e.getFileName(), e.getLineNumber(), e.getCharPositionInLine(), e.getMessage(), e.getLocalizedMessage());
                throw e;
            }
        }
    }

    public void translateToJava(YangPluginConfig pluginConfig) throws IOException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(this.yangNodeSet);
        Collections.sort(yangNodeSortedList);
        for (YangNode node : yangNodeSortedList) {
            if (!node.isToTranslate() || ((YangDeviationHolder)((Object)node)).isModuleForDeviation()) continue;
            JavaCodeGeneratorUtil.generateJavaCode(node, pluginConfig);
        }
    }

    private void printLog(String fileName, int line, int position, String msg, String localMsg) {
        String logInfo = "Error in file: " + fileName;
        if (line != 0) {
            logInfo = logInfo + " at line: " + line + " at position: " + position;
        }
        if (msg != null) {
            logInfo = logInfo + "\n" + localMsg;
        }
        log.info(logInfo);
    }

    public void processSerialization(String path, String id) throws IOException {
        ArrayList<YangNodeInfo> nodeInfo = new ArrayList<YangNodeInfo>();
        this.setNodeInfo(this.yangFileInfoSet, nodeInfo);
        this.model = YangCompilerManager.processYangModel(path, nodeInfo, id, false);
        String serFileName = path + "YangMetaData.ser";
        try (FileOutputStream fileOutputStream = new FileOutputStream(serFileName);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(this.model);
        }
    }

    private void setNodeInfo(Set<YangFileInfo> yangFileInfoSet, List<YangNodeInfo> infos) {
        for (YangFileInfo i : yangFileInfoSet) {
            infos.add(new YangNodeInfo(i.getRootNode(), i.isInterJar()));
        }
    }

    private void processCopyYangFile(String path) throws IOException {
        boolean isCreated;
        List<File> files = YangCompilerManager.getListOfFile(this.yangFileInfoSet);
        File targetDir = new File(path);
        if (!targetDir.exists() && !(isCreated = targetDir.mkdirs())) {
            throw new YangCompilerException("failed to create yang resource directory: " + path);
        }
        for (File file : files) {
            Files.copy(file.toPath(), new File(path + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public Set<YangFileInfo> getYangFileInfoSet() {
        return this.yangFileInfoSet;
    }

    public void setYangFileInfoSet(Set<YangFileInfo> yangFileInfoSet) {
        this.yangFileInfoSet = yangFileInfoSet;
    }

    public static YangModel processYangModel(String path, List<YangNodeInfo> info, String modelId, boolean fromUt) {
        DefaultYangModel.Builder b = DefaultYangModel.builder();
        for (YangNodeInfo i : info) {
            YangModuleId id = YangCompilerManager.processModuleId(i.getNode());
            String serFile = path + id.moduleName() + id.revision() + ".ser";
            if (!fromUt) {
                YangCompilerManager.serializeModuleMetaData(serFile, i.getNode());
            }
            String fileName = YangCompilerManager.getFileName(i.getNode().getFileName());
            YangModuleExtendedInfo module = new YangModuleExtendedInfo(id, new File(path + fileName), new File(serFile), i.isInterJar());
            module.setSchema(i.getNode());
            b.addModule(id, (YangModule)module);
        }
        return b.addModelId(modelId).build();
    }

    private static String getFileName(String absPath) {
        String[] file = absPath.split(SLASH);
        return file[file.length - 1];
    }

    private static void serializeModuleMetaData(String serFileName, YangNode node) {
        try (FileOutputStream outStream = new FileOutputStream(serFileName);
             ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);){
            objOutStream.writeObject(node);
        }
        catch (IOException e) {
            log.info("Error while serializing YANG node", (Throwable)e);
        }
    }

    public static YangModuleId processModuleId(YangNode module) {
        String rev = DataModelUtils.getDateInStringFormat(module);
        return new DefaultYangModuleId(module.getName(), rev);
    }

    private static YangModel getModelForSerialization(String path, Set<YangFileInfo> list, String modelId, boolean fromUt) {
        DefaultYangModel.Builder b = DefaultYangModel.builder();
        for (YangFileInfo info : list) {
            YangNode node = info.getRootNode();
            YangModuleId id = YangCompilerManager.processModuleId(node);
            boolean interJar = info.isInterJar();
            String serFile = path + id.moduleName() + id.revision() + ".ser";
            if (!fromUt) {
                YangCompilerManager.serializeModuleMetaData(serFile, node);
            }
            String fileName = YangCompilerManager.getFileName(node.getFileName());
            YangModuleExtendedInfo module = new YangModuleExtendedInfo(id, new File(path + fileName), new File(serFile), interJar);
            module.setSchema(node);
            b.addModule(id, (YangModule)module);
        }
        return b.addModelId(modelId).build();
    }

    private static List<File> getListOfFile(Set<YangFileInfo> yangFileInfo) {
        ArrayList<File> files = new ArrayList<File>();
        for (YangFileInfo yangFile : yangFileInfo) {
            if (!yangFile.isForTranslator()) continue;
            files.add(new File(yangFile.getYangFileName()));
        }
        return files;
    }

    public static YangModel deSerializeDataModel(String info) throws IOException {
        YangModel model;
        try (FileInputStream fileInputStream = new FileInputStream(info);
             ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
            model = (YangModel)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IOException(info + " failed to fetch nodes due to " + e.getLocalizedMessage(), e);
        }
        return model;
    }

    public static Set<YangNode> getYangNodes(YangModel model) {
        HashSet<YangNode> yangNodes = new HashSet<YangNode>();
        if (model != null) {
            Set modules = model.getYangModules();
            for (YangModule info : modules) {
                yangNodes.add(((YangModuleExtendedInfo)info).getSchema());
            }
        }
        return yangNodes;
    }

    public static void setNodeInfo(YangModel model, List<YangNodeInfo> infos) {
        for (YangModule m : model.getYangModules()) {
            YangModuleExtendedInfo i = (YangModuleExtendedInfo)m;
            infos.add(new YangNodeInfo(i.getSchema(), i.isInterJar()));
        }
    }

    public static YangModel parseJarFile(String jarFile, String directory) throws IOException {
        YangModel model = null;
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> enumEntries = jar.entries();
            File dir = new File(directory + SLASH + "yang/resources");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                if (!file.getName().endsWith("YangMetaData.ser") && !file.getName().endsWith(".yang")) continue;
                String name = YangCompilerManager.getFileName(file.getName());
                File serializedFile = new File(directory + SLASH + "yang/resources" + SLASH + name);
                if (file.isDirectory()) {
                    serializedFile.mkdirs();
                    continue;
                }
                InputStream inputStream = jar.getInputStream(file);
                Throwable throwable = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(serializedFile);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    if (!serializedFile.getName().endsWith("YangMetaData.ser")) continue;
                    model = YangCompilerManager.deSerializeDataModel(serializedFile.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    YangCompilerManager.$closeResource(throwable, inputStream);
                }
            }
        }
        return model;
    }
}

