/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.utils.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    public static void appendFileContents(File toAppend, File srcFile) throws IOException {
        FileSystemUtil.updateFileHandle(srcFile, FileSystemUtil.readAppendFile(toAppend.toString(), "    "), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAppendFile(String toAppend, String spaces) throws IOException {
        FileReader fileReader = new FileReader(toAppend);
        BufferedReader bufferReader = new BufferedReader(fileReader);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String line = bufferReader.readLine();
            while (line != null) {
                switch (line) {
                    case " ": 
                    case "": 
                    case "        ": 
                    case "\n\n": {
                        stringBuilder.append("\n");
                        break;
                    }
                    case "    ": {
                        stringBuilder.append("");
                        break;
                    }
                    default: {
                        String append = spaces + line;
                        stringBuilder.append(append);
                        stringBuilder.append("\n");
                    }
                }
                line = bufferReader.readLine();
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            fileReader.close();
            bufferReader.close();
        }
    }

    public static void updateFileHandle(File inputFile, String contentTobeAdded, boolean isClose) throws IOException {
        if (!isClose) {
            FileWriter fileWriter = new FileWriter(inputFile, true);
            PrintWriter outputPrintWriter = new PrintWriter((Writer)fileWriter, true);
            outputPrintWriter.write(contentTobeAdded);
            outputPrintWriter.flush();
            outputPrintWriter.close();
        }
    }

    public static void closeFile(File file, boolean toBeDeleted) throws IOException {
        if (file != null) {
            boolean deleted;
            FileSystemUtil.updateFileHandle(file, null, true);
            if (toBeDeleted && file.exists() && !(deleted = file.delete())) {
                throw new IOException("Failed to delete temporary file " + file.getName());
            }
        }
    }

    public static void closeFile(File file) throws IOException {
        FileSystemUtil.closeFile(file, true);
    }
}

