/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.linkaccesstype;

/**
 * Represents ENUM data of linkAccessTypeEnum.
 */
public enum LinkAccessTypeEnum {

    /**
     * Represents broadcast.
     */
    BROADCAST(0, "broadcast"),

    /**
     * Represents non-broadcast-multiaccess.
     */
    NON_BROADCAST_MULTIACCESS(1, "non-broadcast-multiaccess"),

    /**
     * Represents point-to-multipoint.
     */
    POINT_TO_MULTIPOINT(2, "point-to-multipoint"),

    /**
     * Represents point-to-point.
     */
    POINT_TO_POINT(3, "point-to-point");

    private int linkAccessTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of linkAccessTypeEnum.
     *
     * @param linkAccessTypeEnum value of linkAccessTypeEnum
     */
     LinkAccessTypeEnum(int linkAccessTypeEnum, String schemaName) {
        this.linkAccessTypeEnum = linkAccessTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of linkAccessTypeEnum for.
     *
     * @param value value of linkAccessTypeEnum for
     * @return linkAccessTypeEnum for
     */
    public static LinkAccessTypeEnum of(int value) {
        switch (value) {
            case 0:
                return LinkAccessTypeEnum.BROADCAST;
            case 1:
                return LinkAccessTypeEnum.NON_BROADCAST_MULTIACCESS;
            case 2:
                return LinkAccessTypeEnum.POINT_TO_MULTIPOINT;
            case 3:
                return LinkAccessTypeEnum.POINT_TO_POINT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of linkAccessTypeEnum for.
     *
     * @param value value of linkAccessTypeEnum for
     * @return linkAccessTypeEnum for
     */
    public static LinkAccessTypeEnum of(String value) {
        switch (value) {
            case "broadcast":
                return LinkAccessTypeEnum.BROADCAST;
            case "non-broadcast-multiaccess":
                return LinkAccessTypeEnum.NON_BROADCAST_MULTIACCESS;
            case "point-to-multipoint":
                return LinkAccessTypeEnum.POINT_TO_MULTIPOINT;
            case "point-to-point":
                return LinkAccessTypeEnum.POINT_TO_POINT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute linkAccessTypeEnum.
     *
     * @return linkAccessTypeEnum value of linkAccessTypeEnum
     */
    public int linkAccessTypeEnum() {
        return linkAccessTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
