/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of teActionSuccess.
 */
public abstract class TeActionSuccess extends TeActionResult {

    /**
     * Returns the attribute te-action-success.
     *
     * @return te-action-success value of te-action-success
     */
    public static String teActionSuccessToString() {
        return "te-action-success";
    }

    /**
     * Returns the object of teActionSuccess fromString input String teActionSuccess.
     *
     * @param valInString value of input String
     * @return teActionSuccess
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("te-action-success")) {
            return TeActionSuccess.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}