/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.performancemetricthrottlecontainer.throttle;

import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.BandwidthIeeeFloat32;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of thresholdOut.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultThresholdOut extends InnerModelObject implements ThresholdOut {
    protected long unidirectionalDelay;
    protected long unidirectionalMinDelay;
    protected long unidirectionalMaxDelay;
    protected long unidirectionalDelayVariation;
    protected BigDecimal unidirectionalPacketLoss;
    protected BandwidthIeeeFloat32 unidirectionalResidualBandwidth;
    protected BandwidthIeeeFloat32 unidirectionalAvailableBandwidth;
    protected BandwidthIeeeFloat32 unidirectionalUtilizedBandwidth;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public long unidirectionalDelay() {
        return unidirectionalDelay;
    }

    @Override
    public long unidirectionalMinDelay() {
        return unidirectionalMinDelay;
    }

    @Override
    public long unidirectionalMaxDelay() {
        return unidirectionalMaxDelay;
    }

    @Override
    public long unidirectionalDelayVariation() {
        return unidirectionalDelayVariation;
    }

    @Override
    public BigDecimal unidirectionalPacketLoss() {
        return unidirectionalPacketLoss;
    }

    @Override
    public BandwidthIeeeFloat32 unidirectionalResidualBandwidth() {
        return unidirectionalResidualBandwidth;
    }

    @Override
    public BandwidthIeeeFloat32 unidirectionalAvailableBandwidth() {
        return unidirectionalAvailableBandwidth;
    }

    @Override
    public BandwidthIeeeFloat32 unidirectionalUtilizedBandwidth() {
        return unidirectionalUtilizedBandwidth;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void unidirectionalDelay(long unidirectionalDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALDELAY.getLeafIndex());
        this.unidirectionalDelay = unidirectionalDelay;
    }

    @Override
    public void unidirectionalMinDelay(long unidirectionalMinDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALMINDELAY.getLeafIndex());
        this.unidirectionalMinDelay = unidirectionalMinDelay;
    }

    @Override
    public void unidirectionalMaxDelay(long unidirectionalMaxDelay) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALMAXDELAY.getLeafIndex());
        this.unidirectionalMaxDelay = unidirectionalMaxDelay;
    }

    @Override
    public void unidirectionalDelayVariation(long unidirectionalDelayVariation) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALDELAYVARIATION.getLeafIndex());
        this.unidirectionalDelayVariation = unidirectionalDelayVariation;
    }

    @Override
    public void unidirectionalPacketLoss(BigDecimal unidirectionalPacketLoss) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALPACKETLOSS.getLeafIndex());
        this.unidirectionalPacketLoss = unidirectionalPacketLoss;
    }

    @Override
    public void unidirectionalResidualBandwidth(BandwidthIeeeFloat32 unidirectionalResidualBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALRESIDUALBANDWIDTH.getLeafIndex());
        this.unidirectionalResidualBandwidth = unidirectionalResidualBandwidth;
    }

    @Override
    public void unidirectionalAvailableBandwidth(BandwidthIeeeFloat32 unidirectionalAvailableBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALAVAILABLEBANDWIDTH.getLeafIndex());
        this.unidirectionalAvailableBandwidth = unidirectionalAvailableBandwidth;
    }

    @Override
    public void unidirectionalUtilizedBandwidth(BandwidthIeeeFloat32 unidirectionalUtilizedBandwidth) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALUTILIZEDBANDWIDTH.getLeafIndex());
        this.unidirectionalUtilizedBandwidth = unidirectionalUtilizedBandwidth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(unidirectionalDelay, unidirectionalMinDelay, unidirectionalMaxDelay, unidirectionalDelayVariation, unidirectionalPacketLoss, unidirectionalResidualBandwidth, unidirectionalAvailableBandwidth, unidirectionalUtilizedBandwidth, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultThresholdOut) {
            DefaultThresholdOut other = (DefaultThresholdOut) obj;
            return
                Objects.deepEquals(unidirectionalDelay, other.unidirectionalDelay) &&
                Objects.deepEquals(unidirectionalMinDelay, other.unidirectionalMinDelay) &&
                Objects.deepEquals(unidirectionalMaxDelay, other.unidirectionalMaxDelay) &&
                Objects.deepEquals(unidirectionalDelayVariation, other.unidirectionalDelayVariation) &&
                Objects.deepEquals(unidirectionalPacketLoss, other.unidirectionalPacketLoss) &&
                Objects.deepEquals(unidirectionalResidualBandwidth, other.unidirectionalResidualBandwidth) &&
                Objects.deepEquals(unidirectionalAvailableBandwidth, other.unidirectionalAvailableBandwidth) &&
                Objects.deepEquals(unidirectionalUtilizedBandwidth, other.unidirectionalUtilizedBandwidth) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("unidirectionalDelay=" + unidirectionalDelay)
            .add("unidirectionalMinDelay=" + unidirectionalMinDelay)
            .add("unidirectionalMaxDelay=" + unidirectionalMaxDelay)
            .add("unidirectionalDelayVariation=" + unidirectionalDelayVariation)
            .add("unidirectionalPacketLoss=" + unidirectionalPacketLoss)
            .add("unidirectionalResidualBandwidth=" + unidirectionalResidualBandwidth)
            .add("unidirectionalAvailableBandwidth=" + unidirectionalAvailableBandwidth)
            .add("unidirectionalUtilizedBandwidth=" + unidirectionalUtilizedBandwidth)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultThresholdOut.
     */
    public DefaultThresholdOut() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}