/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.type;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.GeneralizedLabel;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of label.
 */
public interface Label extends Type, Augmentable  {

    /**
     * Identify the leaf of Label.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents value.
         */
        VALUE(1),
        /**
         * Represents labelFlags.
         */
        LABELFLAGS(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute value.
     *
     * @return value value of value
     */
    GeneralizedLabel value();

    /**
     * Returns the attribute labelFlags.
     *
     * @return labelFlags value of labelFlags
     */
    byte[] labelFlags();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute value.
     *
     * @param value value of value
     */
    void value(GeneralizedLabel value);

    /**
     * Sets the attribute labelFlags.
     *
     * @param labelFlags value of labelFlags
     */
    void labelFlags(byte[] labelFlags);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}