/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.tehoptype;

/**
 * Represents ENUM data of teHopTypeEnum.
 */
public enum TeHopTypeEnum {

    /**
     * Represents lOOSE.
     */
    LOOSE(0, "LOOSE"),

    /**
     * Represents sTRICT.
     */
    STRICT(1, "STRICT");

    private int teHopTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of teHopTypeEnum.
     *
     * @param teHopTypeEnum value of teHopTypeEnum
     */
     TeHopTypeEnum(int teHopTypeEnum, String schemaName) {
        this.teHopTypeEnum = teHopTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teHopTypeEnum for.
     *
     * @param value value of teHopTypeEnum for
     * @return teHopTypeEnum for
     */
    public static TeHopTypeEnum of(int value) {
        switch (value) {
            case 0:
                return TeHopTypeEnum.LOOSE;
            case 1:
                return TeHopTypeEnum.STRICT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teHopTypeEnum for.
     *
     * @param value value of teHopTypeEnum for
     * @return teHopTypeEnum for
     */
    public static TeHopTypeEnum of(String value) {
        switch (value) {
            case "LOOSE":
                return TeHopTypeEnum.LOOSE;
            case "STRICT":
                return TeHopTypeEnum.STRICT;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teHopTypeEnum.
     *
     * @return teHopTypeEnum value of teHopTypeEnum
     */
    public int teHopTypeEnum() {
        return teHopTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
