/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.exampleops.rev20160707.exampleops.reboot;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of rebootOutput.
 */
public class DefaultRebootOutput extends InnerModelObject implements RebootOutput {
    protected String rebootTime;
    protected String message;
    protected String language;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String rebootTime() {
        return rebootTime;
    }

    @Override
    public String message() {
        return message;
    }

    @Override
    public String language() {
        return language;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void rebootTime(String rebootTime) {
        valueLeafFlags.set(LeafIdentifier.REBOOTTIME.getLeafIndex());
        this.rebootTime = rebootTime;
    }

    @Override
    public void message(String message) {
        valueLeafFlags.set(LeafIdentifier.MESSAGE.getLeafIndex());
        this.message = message;
    }

    @Override
    public void language(String language) {
        valueLeafFlags.set(LeafIdentifier.LANGUAGE.getLeafIndex());
        this.language = language;
    }

    @Override
    public int hashCode() {
        return Objects.hash(rebootTime, message, language, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRebootOutput) {
            DefaultRebootOutput other = (DefaultRebootOutput) obj;
            return
                Objects.deepEquals(rebootTime, other.rebootTime) &&
                Objects.deepEquals(message, other.message) &&
                Objects.deepEquals(language, other.language) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("rebootTime=" + rebootTime)
            .add("message=" + message)
            .add("language=" + language)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultRebootOutput.
     */
    public DefaultRebootOutput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}