/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.encryption;

/**
 * Represents ENUM data of layerEnum.
 */
public enum LayerEnum {

    /**
     * Represents layer2.
     */
    LAYER2(0, "layer2"),

    /**
     * Represents layer3.
     */
    LAYER3(1, "layer3");

    private int layerEnum;
    private String schemaName;

    /**
     * Creates an instance of layerEnum.
     *
     * @param layerEnum value of layerEnum
     */
     LayerEnum(int layerEnum, String schemaName) {
        this.layerEnum = layerEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of layerEnum for.
     *
     * @param value value of layerEnum for
     * @return layerEnum for
     */
    public static LayerEnum of(int value) {
        switch (value) {
            case 0:
                return LayerEnum.LAYER2;
            case 1:
                return LayerEnum.LAYER3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of layerEnum for.
     *
     * @param value value of layerEnum for
     * @return layerEnum for
     */
    public static LayerEnum of(String value) {
        switch (value) {
            case "layer2":
                return LayerEnum.LAYER2;
            case "layer3":
                return LayerEnum.LAYER3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute layerEnum.
     *
     * @return layerEnum value of layerEnum
     */
    public int layerEnum() {
        return layerEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
