/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.RpDiscovery;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.RpGroupMappings;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of rp.
 */
public interface Rp extends Augmentable  {

    /**
     * Returns the attribute rpGroupMappings.
     *
     * @return rpGroupMappings value of rpGroupMappings
     */
    RpGroupMappings rpGroupMappings();

    /**
     * Returns the attribute rpDiscovery.
     *
     * @return rpDiscovery value of rpDiscovery
     */
    RpDiscovery rpDiscovery();

    /**
     * Sets the attribute rpGroupMappings.
     *
     * @param rpGroupMappings value of rpGroupMappings
     */
    void rpGroupMappings(RpGroupMappings rpGroupMappings);

    /**
     * Sets the attribute rpDiscovery.
     *
     * @param rpDiscovery value of rpDiscovery
     */
    void rpDiscovery(RpDiscovery rpDiscovery);

}