/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.ExtendedCommunity;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity.routetargetextendedcommunitycase2.RouteTargetExtendedCommunity2;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of routeTargetExtendedCommunityCase2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRouteTargetExtendedCommunityCase2 extends InnerModelObject implements RouteTargetExtendedCommunityCase2 {
    protected RouteTargetExtendedCommunity2 routeTargetExtendedCommunity2;

    @Override
    public RouteTargetExtendedCommunity2 routeTargetExtendedCommunity2() {
        return routeTargetExtendedCommunity2;
    }

    @Override
    public void routeTargetExtendedCommunity2(RouteTargetExtendedCommunity2 routeTargetExtendedCommunity2) {
        this.routeTargetExtendedCommunity2 = routeTargetExtendedCommunity2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(routeTargetExtendedCommunity2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRouteTargetExtendedCommunityCase2) {
            DefaultRouteTargetExtendedCommunityCase2 other = (DefaultRouteTargetExtendedCommunityCase2) obj;
            return
                Objects.deepEquals(routeTargetExtendedCommunity2, other.routeTargetExtendedCommunity2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("routeTargetExtendedCommunity2=" + routeTargetExtendedCommunity2)
            .toString();
    }


    /**
     * Creates an instance of defaultRouteTargetExtendedCommunityCase2.
     */
    public DefaultRouteTargetExtendedCommunityCase2() {
    }

}