/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.tpdfbit;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of bits.
 */
public enum Bits {

    /**
     * Represents b1.
     */
    B1(0, "b1"),

    /**
     * Represents b2.
     */
    B2(1, "b2"),

    /**
     * Represents b3.
     */
    B3(2, "b3");

    private int bits;
    private String schemaName;

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
     Bits(int bits, String schemaName) {
        this.bits = bits;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(int value) {
        switch (value) {
            case 0:
                return Bits.B1;
            case 1:
                return Bits.B2;
            case 2:
                return Bits.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(String value) {
        switch (value) {
            case "b1":
                return Bits.B1;
            case "b2":
                return Bits.B2;
            case "b3":
                return Bits.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public int bits() {
        return bits;
    }

    /**
     * Returns the object of bits fromString input String bits.
     *
     * @param valInString value of input String
     * @return bits
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Bits bits = of(bitName);
            if (bits != null) {
                tmpVal.set(bits.bits());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Bits.B1.bits())) {
            sBuild.append("b1");
            sBuild.append(" ");
        }
        if (bits.get(Bits.B2.bits())) {
            sBuild.append("b2");
            sBuild.append(" ");
        }
        if (bits.get(Bits.B3.bits())) {
            sBuild.append("b3");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
