/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.reboot.output;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.reboot.output.augmentedoutput.Bw;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedOutput.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedOutput extends InnerModelObject implements AugmentedOutput {
    protected Bw bw;

    @Override
    public Bw bw() {
        return bw;
    }

    @Override
    public void bw(Bw bw) {
        this.bw = bw;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bw);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedOutput) {
            DefaultAugmentedOutput other = (DefaultAugmentedOutput) obj;
            return
                Objects.deepEquals(bw, other.bw);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("bw=" + bw)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedOutput.
     */
    public DefaultAugmentedOutput() {
    }

}