/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of errorNoSuchSubscription.
 */
public abstract class ErrorNoSuchSubscription extends Error {

    /**
     * Returns the attribute error-no-such-subscription.
     *
     * @return error-no-such-subscription value of error-no-such-subscription
     */
    public static String errorNoSuchSubscriptionToString() {
        return "error-no-such-subscription";
    }

    /**
     * Returns the object of errorNoSuchSubscription fromString input String errorNoSuchSubscription.
     *
     * @param valInString value of input String
     * @return errorNoSuchSubscription
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("error-no-such-subscription")) {
            return ErrorNoSuchSubscription.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}