/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.filters;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.FilterId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of filter.
 */
public class FilterKeys implements KeyInfo<DefaultFilter> {
    protected FilterId filterId;
    /**
     * Returns the attribute filterId.
     *
     * @return filterId value of filterId
     */
    public FilterId filterId() {
        return filterId;
    }

    /**
     * Sets the value to attribute filterId.
     *
     * @param filterId value of filterId
     */
    public void filterId(FilterId filterId) {
        this.filterId = filterId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(filterId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilterKeys) {
            FilterKeys other = (FilterKeys) obj;
            return
                Objects.deepEquals(filterId, other.filterId);
        }
        return false;
    }
}