/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.Interfaces;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.InterfacesState;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yrtIetfInterfaces.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YrtIetfInterfacesOpParam extends InnerModelObject implements YrtIetfInterfaces {
    protected Interfaces interfaces;
    protected InterfacesState interfacesState;

    @Override
    public Interfaces interfaces() {
        return interfaces;
    }

    @Override
    public InterfacesState interfacesState() {
        return interfacesState;
    }

    @Override
    public void interfaces(Interfaces interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public void interfacesState(InterfacesState interfacesState) {
        this.interfacesState = interfacesState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(interfaces, interfacesState);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YrtIetfInterfacesOpParam) {
            YrtIetfInterfacesOpParam other = (YrtIetfInterfacesOpParam) obj;
            return
                Objects.deepEquals(interfaces, other.interfaces) &&
                Objects.deepEquals(interfacesState, other.interfacesState);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("interfaces=" + interfaces)
            .add("interfacesState=" + interfacesState)
            .toString();
    }

    /**
     * Creates an instance of yrtIetfInterfacesOpParam.
     */
    public YrtIetfInterfacesOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}