/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.YangAutoPrefixInterface;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of interfacesState.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInterfacesState extends InnerModelObject implements InterfacesState {
    protected List<YangAutoPrefixInterface> yangAutoPrefixInterface;

    @Override
    public List<YangAutoPrefixInterface> yangAutoPrefixInterface() {
        return yangAutoPrefixInterface;
    }

    @Override
    public void yangAutoPrefixInterface(List<YangAutoPrefixInterface> yangAutoPrefixInterface) {
        this.yangAutoPrefixInterface = yangAutoPrefixInterface;
    }

    @Override
    public void addToYangAutoPrefixInterface(YangAutoPrefixInterface addTo) {
        if (yangAutoPrefixInterface == null) {
            yangAutoPrefixInterface = new ArrayList<>();
        }
        yangAutoPrefixInterface.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixInterface);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInterfacesState) {
            DefaultInterfacesState other = (DefaultInterfacesState) obj;
            return
                Objects.deepEquals(yangAutoPrefixInterface, other.yangAutoPrefixInterface);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixInterface=" + yangAutoPrefixInterface)
            .toString();
    }


    /**
     * Creates an instance of defaultInterfacesState.
     */
    public DefaultInterfacesState() {
    }

}