/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.InterfaceType;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.AdminStatusEnum;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.OperStatusEnum;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.interfacesstate.yangautoprefixinterface.Statistics;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Gauge64;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.PhysAddress;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of yangAutoPrefixInterface.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYangAutoPrefixInterface extends InnerModelObject 
        implements YangAutoPrefixInterface, MultiInstanceObject<YangAutoPrefixInterfaceKeys> {
    protected String name;
    protected Class<? extends InterfaceType> type;
    protected AdminStatusEnum adminStatus;
    protected OperStatusEnum operStatus;
    protected DateAndTime lastChange;
    protected int ifIndex;
    protected PhysAddress physAddress;
    protected Gauge64 speed;
    protected List<String> higherLayerIf;
    protected List<String> lowerLayerIf;
    protected BitSet valueLeafFlags = new BitSet();
    protected Statistics statistics;

    @Override
    public String name() {
        return name;
    }

    @Override
    public Class<? extends InterfaceType> type() {
        return type;
    }

    @Override
    public AdminStatusEnum adminStatus() {
        return adminStatus;
    }

    @Override
    public OperStatusEnum operStatus() {
        return operStatus;
    }

    @Override
    public DateAndTime lastChange() {
        return lastChange;
    }

    @Override
    public int ifIndex() {
        return ifIndex;
    }

    @Override
    public PhysAddress physAddress() {
        return physAddress;
    }

    @Override
    public Gauge64 speed() {
        return speed;
    }

    @Override
    public List<String> higherLayerIf() {
        return higherLayerIf;
    }

    @Override
    public List<String> lowerLayerIf() {
        return lowerLayerIf;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Statistics statistics() {
        return statistics;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void type(Class<? extends InterfaceType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void adminStatus(AdminStatusEnum adminStatus) {
        valueLeafFlags.set(LeafIdentifier.ADMINSTATUS.getLeafIndex());
        this.adminStatus = adminStatus;
    }

    @Override
    public void operStatus(OperStatusEnum operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void lastChange(DateAndTime lastChange) {
        valueLeafFlags.set(LeafIdentifier.LASTCHANGE.getLeafIndex());
        this.lastChange = lastChange;
    }

    @Override
    public void ifIndex(int ifIndex) {
        valueLeafFlags.set(LeafIdentifier.IFINDEX.getLeafIndex());
        this.ifIndex = ifIndex;
    }

    @Override
    public void physAddress(PhysAddress physAddress) {
        valueLeafFlags.set(LeafIdentifier.PHYSADDRESS.getLeafIndex());
        this.physAddress = physAddress;
    }

    @Override
    public void speed(Gauge64 speed) {
        valueLeafFlags.set(LeafIdentifier.SPEED.getLeafIndex());
        this.speed = speed;
    }

    @Override
    public void higherLayerIf(List<String> higherLayerIf) {
        valueLeafFlags.set(LeafIdentifier.HIGHERLAYERIF.getLeafIndex());
        this.higherLayerIf = higherLayerIf;
    }

    @Override
    public void lowerLayerIf(List<String> lowerLayerIf) {
        valueLeafFlags.set(LeafIdentifier.LOWERLAYERIF.getLeafIndex());
        this.lowerLayerIf = lowerLayerIf;
    }

    @Override
    public void statistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public void addToHigherLayerIf(String addTo) {
        if (higherLayerIf == null) {
            higherLayerIf = new ArrayList<>();
        }
        higherLayerIf.add(addTo);
    }


    @Override
    public void addToLowerLayerIf(String addTo) {
        if (lowerLayerIf == null) {
            lowerLayerIf = new ArrayList<>();
        }
        lowerLayerIf.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(name, type, adminStatus, operStatus, lastChange, ifIndex, physAddress, speed, higherLayerIf, lowerLayerIf, valueLeafFlags, statistics);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangAutoPrefixInterface) {
            DefaultYangAutoPrefixInterface other = (DefaultYangAutoPrefixInterface) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(adminStatus, other.adminStatus) &&
                Objects.deepEquals(operStatus, other.operStatus) &&
                Objects.deepEquals(lastChange, other.lastChange) &&
                Objects.deepEquals(ifIndex, other.ifIndex) &&
                Objects.deepEquals(physAddress, other.physAddress) &&
                Objects.deepEquals(speed, other.speed) &&
                Objects.deepEquals(higherLayerIf, other.higherLayerIf) &&
                Objects.deepEquals(lowerLayerIf, other.lowerLayerIf) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(statistics, other.statistics);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("type=" + type)
            .add("adminStatus=" + adminStatus)
            .add("operStatus=" + operStatus)
            .add("lastChange=" + lastChange)
            .add("ifIndex=" + ifIndex)
            .add("physAddress=" + physAddress)
            .add("speed=" + speed)
            .add("higherLayerIf=" + higherLayerIf)
            .add("lowerLayerIf=" + lowerLayerIf)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("statistics=" + statistics)
            .toString();
    }


    /**
     * Creates an instance of defaultYangAutoPrefixInterface.
     */
    public DefaultYangAutoPrefixInterface() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}