/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of protOdu2e.
 */
public abstract class ProtOdu2e extends TributaryProtocolType {

    /**
     * Returns the attribute prot-ODU2e.
     *
     * @return prot-ODU2e value of prot-ODU2e
     */
    public static String protOdu2eToString() {
        return "prot-ODU2e";
    }

    /**
     * Returns the object of protOdu2e fromString input String protOdu2e.
     *
     * @param valInString value of input String
     * @return protOdu2e
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-ODU2e")) {
            return ProtOdu2e.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}