/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.scheduleconfigattributes;

/**
 * Represents ENUM data of inclusiveExclusiveEnum.
 */
public enum InclusiveExclusiveEnum {

    /**
     * Represents inclusive.
     */
    INCLUSIVE(0, "inclusive"),

    /**
     * Represents exclusive.
     */
    EXCLUSIVE(1, "exclusive");

    private int inclusiveExclusiveEnum;
    private String schemaName;

    /**
     * Creates an instance of inclusiveExclusiveEnum.
     *
     * @param inclusiveExclusiveEnum value of inclusiveExclusiveEnum
     */
     InclusiveExclusiveEnum(int inclusiveExclusiveEnum, String schemaName) {
        this.inclusiveExclusiveEnum = inclusiveExclusiveEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of inclusiveExclusiveEnum for.
     *
     * @param value value of inclusiveExclusiveEnum for
     * @return inclusiveExclusiveEnum for
     */
    public static InclusiveExclusiveEnum of(int value) {
        switch (value) {
            case 0:
                return InclusiveExclusiveEnum.INCLUSIVE;
            case 1:
                return InclusiveExclusiveEnum.EXCLUSIVE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of inclusiveExclusiveEnum for.
     *
     * @param value value of inclusiveExclusiveEnum for
     * @return inclusiveExclusiveEnum for
     */
    public static InclusiveExclusiveEnum of(String value) {
        switch (value) {
            case "inclusive":
                return InclusiveExclusiveEnum.INCLUSIVE;
            case "exclusive":
                return InclusiveExclusiveEnum.EXCLUSIVE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute inclusiveExclusiveEnum.
     *
     * @return inclusiveExclusiveEnum value of inclusiveExclusiveEnum
     */
    public int inclusiveExclusiveEnum() {
        return inclusiveExclusiveEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
