/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.globalsgrouping;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups.NamedAdminGroups;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedexplicitpaths.NamedExplicitPaths;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.NamedPathConstraints;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedsrlgs.NamedSrlgs;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of globals.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultGlobals extends InnerModelObject implements Globals {
    protected NamedAdminGroups namedAdminGroups;
    protected NamedSrlgs namedSrlgs;
    protected NamedExplicitPaths namedExplicitPaths;
    protected NamedPathConstraints namedPathConstraints;

    @Override
    public NamedAdminGroups namedAdminGroups() {
        return namedAdminGroups;
    }

    @Override
    public NamedSrlgs namedSrlgs() {
        return namedSrlgs;
    }

    @Override
    public NamedExplicitPaths namedExplicitPaths() {
        return namedExplicitPaths;
    }

    @Override
    public NamedPathConstraints namedPathConstraints() {
        return namedPathConstraints;
    }

    @Override
    public void namedAdminGroups(NamedAdminGroups namedAdminGroups) {
        this.namedAdminGroups = namedAdminGroups;
    }

    @Override
    public void namedSrlgs(NamedSrlgs namedSrlgs) {
        this.namedSrlgs = namedSrlgs;
    }

    @Override
    public void namedExplicitPaths(NamedExplicitPaths namedExplicitPaths) {
        this.namedExplicitPaths = namedExplicitPaths;
    }

    @Override
    public void namedPathConstraints(NamedPathConstraints namedPathConstraints) {
        this.namedPathConstraints = namedPathConstraints;
    }

    @Override
    public int hashCode() {
        return Objects.hash(namedAdminGroups, namedSrlgs, namedExplicitPaths, namedPathConstraints);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultGlobals) {
            DefaultGlobals other = (DefaultGlobals) obj;
            return
                Objects.deepEquals(namedAdminGroups, other.namedAdminGroups) &&
                Objects.deepEquals(namedSrlgs, other.namedSrlgs) &&
                Objects.deepEquals(namedExplicitPaths, other.namedExplicitPaths) &&
                Objects.deepEquals(namedPathConstraints, other.namedPathConstraints);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("namedAdminGroups=" + namedAdminGroups)
            .add("namedSrlgs=" + namedSrlgs)
            .add("namedExplicitPaths=" + namedExplicitPaths)
            .add("namedPathConstraints=" + namedPathConstraints)
            .toString();
    }


    /**
     * Creates an instance of defaultGlobals.
     */
    public DefaultGlobals() {
    }

}