/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.namedpathconstraints.NamedPathConstraint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of namedPathConstraints.
 */
public interface NamedPathConstraints extends Augmentable  {

    /**
     * Returns the attribute namedPathConstraint.
     *
     * @return namedPathConstraint list of namedPathConstraint
     */
    List<NamedPathConstraint> namedPathConstraint();

    /**
     * Sets the attribute namedPathConstraint.
     *
     * @param namedPathConstraint list of namedPathConstraint
     */
    void namedPathConstraint(List<NamedPathConstraint> namedPathConstraint);

    /**
     * Adds to the list of namedPathConstraint.
     *
     * @param addTo value of namedPathConstraint
     */
    void addToNamedPathConstraint(NamedPathConstraint addTo);

}