/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedpathconstraints.namedpathconstraints.namedpathconstraint;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathMetricType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathTiebreakerType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathaffinities.PathAffinities;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects.ExplicitRouteObjects;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathsrlgs.PathSrlgs;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tepathbandwidthtop.Bandwidth;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of state.
 */
public interface State extends Augmentable  {

    /**
     * Identify the leaf of State.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents topologyId.
         */
        TOPOLOGYID(2),
        /**
         * Represents costLimit.
         */
        COSTLIMIT(3),
        /**
         * Represents hopLimit.
         */
        HOPLIMIT(4),
        /**
         * Represents metricType.
         */
        METRICTYPE(5),
        /**
         * Represents tiebreakerType.
         */
        TIEBREAKERTYPE(6),
        /**
         * Represents ignoreOverload.
         */
        IGNOREOVERLOAD(7),
        /**
         * Represents setupPriority.
         */
        SETUPPRIORITY(8),
        /**
         * Represents holdPriority.
         */
        HOLDPRIORITY(9);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute topologyId.
     *
     * @return topologyId value of topologyId
     */
    TeTopologyId topologyId();

    /**
     * Returns the attribute costLimit.
     *
     * @return costLimit value of costLimit
     */
    long costLimit();

    /**
     * Returns the attribute hopLimit.
     *
     * @return hopLimit value of hopLimit
     */
    short hopLimit();

    /**
     * Returns the attribute metricType.
     *
     * @return metricType value of metricType
     */
    Class<? extends PathMetricType> metricType();

    /**
     * Returns the attribute tiebreakerType.
     *
     * @return tiebreakerType value of tiebreakerType
     */
    Class<? extends PathTiebreakerType> tiebreakerType();

    /**
     * Returns the attribute ignoreOverload.
     *
     * @return ignoreOverload value of ignoreOverload
     */
    boolean ignoreOverload();

    /**
     * Returns the attribute setupPriority.
     *
     * @return setupPriority value of setupPriority
     */
    short setupPriority();

    /**
     * Returns the attribute holdPriority.
     *
     * @return holdPriority value of holdPriority
     */
    short holdPriority();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute pathAffinities.
     *
     * @return pathAffinities value of pathAffinities
     */
    PathAffinities pathAffinities();

    /**
     * Returns the attribute pathSrlgs.
     *
     * @return pathSrlgs value of pathSrlgs
     */
    PathSrlgs pathSrlgs();

    /**
     * Returns the attribute bandwidth.
     *
     * @return bandwidth value of bandwidth
     */
    Bandwidth bandwidth();

    /**
     * Returns the attribute explicitRouteObjects.
     *
     * @return explicitRouteObjects value of explicitRouteObjects
     */
    ExplicitRouteObjects explicitRouteObjects();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute topologyId.
     *
     * @param topologyId value of topologyId
     */
    void topologyId(TeTopologyId topologyId);

    /**
     * Sets the attribute costLimit.
     *
     * @param costLimit value of costLimit
     */
    void costLimit(long costLimit);

    /**
     * Sets the attribute hopLimit.
     *
     * @param hopLimit value of hopLimit
     */
    void hopLimit(short hopLimit);

    /**
     * Sets the attribute metricType.
     *
     * @param metricType value of metricType
     */
    void metricType(Class<? extends PathMetricType> metricType);

    /**
     * Sets the attribute tiebreakerType.
     *
     * @param tiebreakerType value of tiebreakerType
     */
    void tiebreakerType(Class<? extends PathTiebreakerType> tiebreakerType);

    /**
     * Sets the attribute ignoreOverload.
     *
     * @param ignoreOverload value of ignoreOverload
     */
    void ignoreOverload(boolean ignoreOverload);

    /**
     * Sets the attribute setupPriority.
     *
     * @param setupPriority value of setupPriority
     */
    void setupPriority(short setupPriority);

    /**
     * Sets the attribute holdPriority.
     *
     * @param holdPriority value of holdPriority
     */
    void holdPriority(short holdPriority);

    /**
     * Sets the attribute pathAffinities.
     *
     * @param pathAffinities value of pathAffinities
     */
    void pathAffinities(PathAffinities pathAffinities);

    /**
     * Sets the attribute pathSrlgs.
     *
     * @param pathSrlgs value of pathSrlgs
     */
    void pathSrlgs(PathSrlgs pathSrlgs);

    /**
     * Sets the attribute bandwidth.
     *
     * @param bandwidth value of bandwidth
     */
    void bandwidth(Bandwidth bandwidth);

    /**
     * Sets the attribute explicitRouteObjects.
     *
     * @param explicitRouteObjects value of explicitRouteObjects
     */
    void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}