/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pparamsconfig;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeNodeId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTpId;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of hierarchicalLinkId.
 */
public interface HierarchicalLinkId extends Augmentable  {

    /**
     * Identify the leaf of HierarchicalLinkId.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents localTeNodeId.
         */
        LOCALTENODEID(1),
        /**
         * Represents localTeLinkTpId.
         */
        LOCALTELINKTPID(2),
        /**
         * Represents remoteTeNodeId.
         */
        REMOTETENODEID(3),
        /**
         * Represents teTopologyId.
         */
        TETOPOLOGYID(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute localTeNodeId.
     *
     * @return localTeNodeId value of localTeNodeId
     */
    TeNodeId localTeNodeId();

    /**
     * Returns the attribute localTeLinkTpId.
     *
     * @return localTeLinkTpId value of localTeLinkTpId
     */
    TeTpId localTeLinkTpId();

    /**
     * Returns the attribute remoteTeNodeId.
     *
     * @return remoteTeNodeId value of remoteTeNodeId
     */
    TeNodeId remoteTeNodeId();

    /**
     * Returns the attribute teTopologyId.
     *
     * @return teTopologyId value of teTopologyId
     */
    TeTopologyId teTopologyId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute localTeNodeId.
     *
     * @param localTeNodeId value of localTeNodeId
     */
    void localTeNodeId(TeNodeId localTeNodeId);

    /**
     * Sets the attribute localTeLinkTpId.
     *
     * @param localTeLinkTpId value of localTeLinkTpId
     */
    void localTeLinkTpId(TeTpId localTeLinkTpId);

    /**
     * Sets the attribute remoteTeNodeId.
     *
     * @param remoteTeNodeId value of remoteTeNodeId
     */
    void remoteTeNodeId(TeNodeId remoteTeNodeId);

    /**
     * Sets the attribute teTopologyId.
     *
     * @param teTopologyId value of teTopologyId
     */
    void teTopologyId(TeTopologyId teTopologyId);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}