/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2pprimarypaths.p2pprimarypath.candidatep2psecondarypaths.CandidateP2PsecondaryPath;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of candidateP2PsecondaryPaths.
 */
public interface CandidateP2PsecondaryPaths extends Augmentable  {

    /**
     * Returns the attribute candidateP2PsecondaryPath.
     *
     * @return candidateP2PsecondaryPath list of candidateP2PsecondaryPath
     */
    List<CandidateP2PsecondaryPath> candidateP2PsecondaryPath();

    /**
     * Sets the attribute candidateP2PsecondaryPath.
     *
     * @param candidateP2PsecondaryPath list of candidateP2PsecondaryPath
     */
    void candidateP2PsecondaryPath(List<CandidateP2PsecondaryPath> candidateP2PsecondaryPath);

    /**
     * Adds to the list of candidateP2PsecondaryPath.
     *
     * @param addTo value of candidateP2PsecondaryPath
     */
    void addToCandidateP2PsecondaryPath(CandidateP2PsecondaryPath addTo);

}