/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelp2pproperties.p2psecondarypaths;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of p2PsecondaryPath.
 */
public class P2PsecondaryPathKeys implements KeyInfo<DefaultP2PsecondaryPath> {
    protected Object name;
    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    public Object name() {
        return name;
    }

    /**
     * Sets the value to attribute name.
     *
     * @param name value of name
     */
    public void name(Object name) {
        this.name = name;
    }


    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof P2PsecondaryPathKeys) {
            P2PsecondaryPathKeys other = (P2PsecondaryPathKeys) obj;
            return
                Objects.deepEquals(name, other.name);
        }
        return false;
    }
}