/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.p2pprimarypaths.P2PprimaryPath;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of p2PprimaryPaths.
 */
public class DefaultP2PprimaryPaths extends InnerModelObject implements P2PprimaryPaths {
    protected List<P2PprimaryPath> p2PprimaryPath;

    @Override
    public List<P2PprimaryPath> p2PprimaryPath() {
        return p2PprimaryPath;
    }

    @Override
    public void p2PprimaryPath(List<P2PprimaryPath> p2PprimaryPath) {
        this.p2PprimaryPath = p2PprimaryPath;
    }

    @Override
    public void addToP2PprimaryPath(P2PprimaryPath addTo) {
        if (p2PprimaryPath == null) {
            p2PprimaryPath = new ArrayList<>();
        }
        p2PprimaryPath.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(p2PprimaryPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultP2PprimaryPaths) {
            DefaultP2PprimaryPaths other = (DefaultP2PprimaryPaths) obj;
            return
                Objects.deepEquals(p2PprimaryPath, other.p2PprimaryPath);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("p2PprimaryPath=" + p2PprimaryPath)
            .toString();
    }


    /**
     * Creates an instance of defaultP2PprimaryPaths.
     */
    public DefaultP2PprimaryPaths() {
    }

}