/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.TargetResourceOffset;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.OperationEnum;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.Value;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.WhereEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of edit.
 */
public interface Edit extends Augmentable  {

    /**
     * Identify the leaf of Edit.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents editId.
         */
        EDITID(1),
        /**
         * Represents operation.
         */
        OPERATION(2),
        /**
         * Represents target.
         */
        TARGET(3),
        /**
         * Represents point.
         */
        POINT(4),
        /**
         * Represents where.
         */
        WHERE(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute editId.
     *
     * @return editId value of editId
     */
    String editId();

    /**
     * Returns the attribute operation.
     *
     * @return operation value of operation
     */
    OperationEnum operation();

    /**
     * Returns the attribute target.
     *
     * @return target value of target
     */
    TargetResourceOffset target();

    /**
     * Returns the attribute point.
     *
     * @return point value of point
     */
    TargetResourceOffset point();

    /**
     * Returns the attribute where.
     *
     * @return where value of where
     */
    WhereEnum where();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute value.
     *
     * @return value value of value
     */
    Value value();

    /**
     * Sets the attribute editId.
     *
     * @param editId value of editId
     */
    void editId(String editId);

    /**
     * Sets the attribute operation.
     *
     * @param operation value of operation
     */
    void operation(OperationEnum operation);

    /**
     * Sets the attribute target.
     *
     * @param target value of target
     */
    void target(TargetResourceOffset target);

    /**
     * Sets the attribute point.
     *
     * @param point value of point
     */
    void point(TargetResourceOffset point);

    /**
     * Sets the attribute where.
     *
     * @param where value of where
     */
    void where(WhereEnum where);

    /**
     * Sets the attribute value.
     *
     * @param value value of value
     */
    void value(Value value);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}