/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionId;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.pushchangeupdate.DatastoreChanges;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of pushChangeUpdate.
 */
public class DefaultPushChangeUpdate extends InnerModelObject implements PushChangeUpdate {
    protected SubscriptionId subscriptionId;
    protected DateAndTime timeOfUpdate;
    protected boolean updatesNotSent;
    protected String datastoreChangesString;
    protected BitSet valueLeafFlags = new BitSet();
    protected DatastoreChanges datastoreChanges;

    @Override
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    @Override
    public DateAndTime timeOfUpdate() {
        return timeOfUpdate;
    }

    @Override
    public boolean updatesNotSent() {
        return updatesNotSent;
    }

    @Override
    public String datastoreChangesString() {
        return datastoreChangesString;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public DatastoreChanges datastoreChanges() {
        return datastoreChanges;
    }

    @Override
    public void subscriptionId(SubscriptionId subscriptionId) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONID.getLeafIndex());
        this.subscriptionId = subscriptionId;
    }

    @Override
    public void timeOfUpdate(DateAndTime timeOfUpdate) {
        valueLeafFlags.set(LeafIdentifier.TIMEOFUPDATE.getLeafIndex());
        this.timeOfUpdate = timeOfUpdate;
    }

    @Override
    public void updatesNotSent(boolean updatesNotSent) {
        valueLeafFlags.set(LeafIdentifier.UPDATESNOTSENT.getLeafIndex());
        this.updatesNotSent = updatesNotSent;
    }

    @Override
    public void datastoreChangesString(String datastoreChangesString) {
        valueLeafFlags.set(LeafIdentifier.DATASTORECHANGESSTRING.getLeafIndex());
        this.datastoreChangesString = datastoreChangesString;
    }

    @Override
    public void datastoreChanges(DatastoreChanges datastoreChanges) {
        this.datastoreChanges = datastoreChanges;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId, timeOfUpdate, updatesNotSent, datastoreChangesString, valueLeafFlags, datastoreChanges);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPushChangeUpdate) {
            DefaultPushChangeUpdate other = (DefaultPushChangeUpdate) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId) &&
                Objects.deepEquals(timeOfUpdate, other.timeOfUpdate) &&
                Objects.deepEquals(updatesNotSent, other.updatesNotSent) &&
                Objects.deepEquals(datastoreChangesString, other.datastoreChangesString) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(datastoreChanges, other.datastoreChanges);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionId=" + subscriptionId)
            .add("timeOfUpdate=" + timeOfUpdate)
            .add("updatesNotSent=" + updatesNotSent)
            .add("datastoreChangesString=" + datastoreChangesString)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("datastoreChanges=" + datastoreChanges)
            .toString();
    }


    /**
     * Creates an instance of defaultPushChangeUpdate.
     */
    public DefaultPushChangeUpdate() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}