/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Error;

/**
 * Represents the implementation of errorDataNotAuthorized.
 */
public abstract class ErrorDataNotAuthorized extends Error {

    /**
     * Returns the attribute error-data-not-authorized.
     *
     * @return error-data-not-authorized value of error-data-not-authorized
     */
    public static String errorDataNotAuthorizedToString() {
        return "error-data-not-authorized";
    }

    /**
     * Returns the object of errorDataNotAuthorized fromString input String errorDataNotAuthorized.
     *
     * @param valInString value of input String
     * @return errorDataNotAuthorized
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("error-data-not-authorized")) {
            return ErrorDataNotAuthorized.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}