/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.establishsubscription.output;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Dscp;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatepolicy.UpdateTrigger;

/**
 * Abstraction of an entity which represents the functionality of augmentedNotifBisOutput.
 */
public interface AugmentedNotifBisOutput {

    /**
     * Identify the leaf of AugmentedNotifBisOutput.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents dscp.
         */
        DSCP(1),
        /**
         * Represents subscriptionPriority.
         */
        SUBSCRIPTIONPRIORITY(2),
        /**
         * Represents subscriptionDependency.
         */
        SUBSCRIPTIONDEPENDENCY(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute dscp.
     *
     * @return dscp value of dscp
     */
    Dscp dscp();

    /**
     * Returns the attribute subscriptionPriority.
     *
     * @return subscriptionPriority value of subscriptionPriority
     */
    short subscriptionPriority();

    /**
     * Returns the attribute subscriptionDependency.
     *
     * @return subscriptionDependency value of subscriptionDependency
     */
    String subscriptionDependency();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute updateTrigger.
     *
     * @return updateTrigger value of updateTrigger
     */
    UpdateTrigger updateTrigger();

    /**
     * Sets the attribute dscp.
     *
     * @param dscp value of dscp
     */
    void dscp(Dscp dscp);

    /**
     * Sets the attribute subscriptionPriority.
     *
     * @param subscriptionPriority value of subscriptionPriority
     */
    void subscriptionPriority(short subscriptionPriority);

    /**
     * Sets the attribute subscriptionDependency.
     *
     * @param subscriptionDependency value of subscriptionDependency
     */
    void subscriptionDependency(String subscriptionDependency);

    /**
     * Sets the attribute updateTrigger.
     *
     * @param updateTrigger value of updateTrigger
     */
    void updateTrigger(UpdateTrigger updateTrigger);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}