/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangBit;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;

public class YangBits
extends DefaultLocationInfo
implements Parsable,
Serializable {
    private static final long serialVersionUID = 806201641L;
    private static final String SPACE = " ";
    private String bitsName;
    private BitSet bitDataSet = new BitSet();
    private Map<String, YangBit> bitNameMap;
    private Map<Integer, YangBit> bitPositionMap;

    public YangBits() {
        this.setBitNameMap(new HashMap<String, YangBit>());
        this.setBitPositionMap(new HashMap<Integer, YangBit>());
    }

    public String getBitsName() {
        return this.bitsName;
    }

    public void setBitsName(String bitsName) {
        this.bitsName = bitsName;
    }

    public BitSet getBitDataSet() {
        return this.bitDataSet;
    }

    public void setBitDataSet(String[] bitNames) throws DataModelException {
        for (String bitName : bitNames) {
            YangBit bit = this.bitNameMap.get(bitName);
            if (bit == null) {
                throw new DataModelException("YANG file error: Unable to find corresponding bit position for bit name: " + bitName + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
            }
            this.bitDataSet.set(bit.getPosition());
        }
    }

    public Map<String, YangBit> getBitNameMap() {
        return this.bitNameMap;
    }

    public void setBitNameMap(Map<String, YangBit> bitNameMap) {
        this.bitNameMap = bitNameMap;
    }

    public boolean isBitNameExists(String bitName) {
        return this.bitNameMap.containsKey(bitName);
    }

    public Map<Integer, YangBit> getBitPositionMap() {
        return this.bitPositionMap;
    }

    public void setBitPositionMap(Map<Integer, YangBit> bitPositionMap) {
        this.bitPositionMap = bitPositionMap;
    }

    public boolean isBitPositionExists(Integer bitPosition) {
        return this.bitPositionMap.containsKey(bitPosition);
    }

    public void addBitInfo(YangBit bitInfo) throws DataModelException {
        if (this.bitNameMap.put(bitInfo.getBitName(), bitInfo) != null) {
            throw new DataModelException("YANG file error: Duplicate bit name detected, same as bit name \"" + bitInfo.getBitName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (this.bitPositionMap.put(bitInfo.getPosition(), bitInfo) != null) {
            throw new DataModelException("YANG file error: Duplicate bit position detected, same as bit position \"" + bitInfo.getPosition() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.BITS_DATA;
    }

    public String toString() {
        String bits = new String();
        int i = this.bitDataSet.nextSetBit(0);
        while (i >= 0) {
            YangBit bit = this.bitPositionMap.get(i);
            if (bit == null) {
                return null;
            }
            bits = bits.isEmpty() ? bit.getBitName() : bits + SPACE + bit.getBitName();
            i = this.bitDataSet.nextSetBit(i + 1);
        }
        return bits.trim();
    }

    public YangBits fromString(String bits) {
        if (bits == null || bits.isEmpty()) {
            this.bitDataSet.clear();
            return this;
        }
        try {
            String[] bitNames = bits.trim().split(Pattern.quote(SPACE));
            this.setBitDataSet(bitNames);
            return this;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }
}

