/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangInt8
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangInt8>,
Serializable {
    private static final long serialVersionUID = 8006201664L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    private final byte value;

    public YangInt8(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = (byte)-128;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = (byte)127;
        } else {
            try {
                this.value = Byte.parseByte(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid int8.");
            }
        }
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangInt8 anotherYangInt8) {
        return Byte.compare(this.value, anotherYangInt8.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.INT8;
    }
}

