/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangUint8
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangUint8>,
Serializable {
    private static final long serialVersionUID = 8006201660L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final short MIN_VALUE = 0;
    public static final short MAX_VALUE = 255;
    private short value;

    public YangUint8(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = 0;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = (short)255;
        } else {
            try {
                this.value = Short.parseShort(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid uint8.");
            }
        }
        if (this.value < 0) {
            throw new DataTypeException("YANG file error : " + valueInString + " is lesser than minimum value " + 0 + ".");
        }
        if (this.value > 255) {
            throw new DataTypeException("YANG file error : " + valueInString + " is greater than maximum value " + 255 + ".");
        }
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangUint8 another) {
        return Short.compare(this.value, another.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.UINT8;
    }
}

