/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import java.util.Map;
import org.onosproject.yang.compiler.datamodel.YangBit;
import org.onosproject.yang.compiler.datamodel.YangBits;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class BitListener {
    private BitListener() {
    }

    public static void processBitEntry(TreeWalkListener listener, GeneratedYangParser.BitStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.BIT_DATA, ctx);
        YangBit bitNode = new YangBit();
        bitNode.setBitName(identifier);
        bitNode.setLineNumber(ctx.getStart().getLine());
        bitNode.setCharPosition(ctx.getStart().getCharPositionInLine());
        bitNode.setFileName(listener.getFileName());
        listener.getParsedDataStack().push(bitNode);
    }

    public static void processBitExit(TreeWalkListener listener, GeneratedYangParser.BitStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpBitNode = listener.getParsedDataStack().peek();
        if (tmpBitNode instanceof YangBit) {
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case BITS_DATA: {
                    YangBits yangBits = (YangBits)tmpNode;
                    if (ctx.bitBodyStatement() == null || ctx.bitBodyStatement().positionStatement() == null) {
                        int maxPosition = 0;
                        boolean isPositionPresent = false;
                        for (Map.Entry<Integer, YangBit> element : yangBits.getBitPositionMap().entrySet()) {
                            if (maxPosition > element.getKey()) continue;
                            maxPosition = element.getKey();
                            isPositionPresent = true;
                        }
                        if (isPositionPresent) {
                            ++maxPosition;
                        }
                        ((YangBit)tmpBitNode).setPosition(maxPosition);
                    }
                    try {
                        yangBits.addBitInfo((YangBit)tmpBitNode);
                        break;
                    }
                    catch (DataModelException e) {
                        ParserException parserException = new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.INVALID_CONTENT, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
                        parserException.setLine(ctx.getStart().getLine());
                        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                        throw parserException;
                    }
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.BIT_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

