/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.tool;

import com.google.common.base.MoreObjects;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.onosproject.yang.compiler.api.YangCompilationParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultYangCompilationParam
implements YangCompilationParam {
    private static final Logger log = LoggerFactory.getLogger(DefaultYangCompilationParam.class);
    private final Set<Path> yangFiles;
    private final Set<Path> dependentSchemas;
    private Path codeGenDir;
    private Path metaDataPath;
    private String modelId;

    private DefaultYangCompilationParam(Set<Path> files, Set<Path> schemas, Path metaPath, String id, Path path) {
        this.yangFiles = Collections.unmodifiableSet(files);
        this.dependentSchemas = Collections.unmodifiableSet(schemas);
        this.modelId = id;
        this.codeGenDir = path;
        this.metaDataPath = metaPath;
    }

    public Set<Path> getYangFiles() {
        return this.yangFiles;
    }

    public Set<Path> getDependentSchemas() {
        return this.dependentSchemas;
    }

    public Path getCodeGenDir() {
        return this.codeGenDir;
    }

    public Path getMetadataGenDir() {
        return this.metaDataPath;
    }

    public String getModelId() {
        return this.modelId;
    }

    public int hashCode() {
        return Objects.hash(this.yangFiles, this.dependentSchemas, this.codeGenDir, this.metaDataPath, this.modelId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultYangCompilationParam that = (DefaultYangCompilationParam)obj;
        return this.yangFiles.size() == that.yangFiles.size() && this.dependentSchemas.size() == that.dependentSchemas.size() && this.yangFiles.containsAll(that.yangFiles) && this.dependentSchemas.containsAll(that.dependentSchemas) && Objects.equals(this.codeGenDir, that.codeGenDir) && Objects.equals(this.metaDataPath, that.metaDataPath) && Objects.equals(this.modelId, that.modelId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("yangFilePath", this.yangFiles).add("dependentSchemas", this.dependentSchemas).add("codeGenDir", (Object)this.codeGenDir).add("metaDataPath", (Object)this.metaDataPath).add("modelId", (Object)this.modelId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Path> yangFiles = new LinkedHashSet<Path>();
        private final Set<Path> dependentSchemas = new LinkedHashSet<Path>();
        private Path codeGenDir;
        private Path metaDataPath;
        private String modelId;

        public Builder setMetadataGenDir(Path path) {
            this.metaDataPath = path;
            return this;
        }

        public Builder setModelId(String id) {
            this.modelId = id;
            return this;
        }

        public Builder setCodeGenDir(Path path) {
            this.codeGenDir = path;
            return this;
        }

        public Builder addDependentSchema(Path path) {
            this.dependentSchemas.add(path);
            return this;
        }

        public Builder addYangFile(Path path) {
            this.yangFiles.add(path);
            return this;
        }

        public DefaultYangCompilationParam build() {
            return new DefaultYangCompilationParam(this.yangFiles, this.dependentSchemas, this.metaDataPath, this.modelId, this.codeGenDir);
        }
    }
}

