/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.JavaImportData;
import org.onosproject.yang.compiler.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yang.compiler.translator.tojava.utils.IndentationType;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodClassTypes;
import org.onosproject.yang.compiler.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yang.compiler.translator.tojava.utils.StringGenerator;
import org.onosproject.yang.compiler.utils.io.impl.FileSystemUtil;
import org.onosproject.yang.compiler.utils.io.impl.JavaDocGen;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public class TempJavaRpcFragmentFiles
extends TempJavaFragmentFiles {
    private File rpcHandlerFileHandler;
    private File rpcExtendedCommandFileHandler;
    private File rpcRegisterFileHandler;
    private static final String VAR_CMD_ID = "cmdId";
    private static final String VAR_RPC_INPUT = "rpcInput";
    private static final String VAR_EXECUTOR = "executor";
    private static final String VAR_RPC_HANDLER = "rpcHandler";
    private static final String VAR_CMD = "cmd";
    private static final String VAR_INPUT = "input";
    private static final String VAR_MSG_ID = "msgId";
    private static final String VAR_RPC_COMMANDS = "rpcCommands";
    private static final String VAR_RPC_COMMAND = "rpcCommand";
    private static final String VAR_CFG_SERVICE = "cfgService";
    private static final String VAR_MODEL_CONVERTER = "modelConverter";
    private static final String VAR_APP_SERVICE = "appService";
    private static final String EXECUTE = "execute";
    private static final String EXECUTE_RPC = "executeRpc";
    private static final String REGISTER_RPC_METHOD = "registerRpc";
    private static final String REGISTER_HANDLER = "registerHandler";
    private static final String CREATE_RPC_CMDS = "createRpcCommands";

    TempJavaRpcFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        this.generateRpcExtendedCommandFile(curNode);
        this.generateRpcHandlerFile(curNode);
        this.generateRpcRegisterFile(curNode);
        this.freeTemporaryResources(false);
    }

    private void generateRpcHandlerFile(YangNode curNode) throws IOException {
        JavaImportData importData = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getRpcFragmentFiles().getJavaImportData();
        List<String> imports = importData.getImports(false);
        imports.add(importData.getExecutorServiceImport());
        imports.add(importData.getExecutorsImport());
        imports.add(importData.getImportForRpcHandler());
        imports.add(importData.getImportForRpcCommand());
        imports.add(importData.getImportForRpcInput());
        this.rpcHandlerFileHandler = this.getJavaFileHandle("DefaultRpcHandler");
        JavaFileGenerator.generateRpcHandler(this.rpcHandlerFileHandler, curNode, imports);
    }

    private void generateRpcExtendedCommandFile(YangNode curNode) throws IOException {
        JavaImportData importData = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getRpcFragmentFiles().getJavaImportData();
        List<String> imports = importData.getImports(false);
        imports.add(importData.getImportForResourceId());
        imports.add(importData.getImportForRpcInput());
        imports.add(importData.getImportForRpcCommand());
        this.rpcExtendedCommandFileHandler = this.getJavaFileHandle("RpcExtendedCommand");
        JavaFileGenerator.generateRpcExtendedCommand(this.rpcExtendedCommandFileHandler, curNode, imports);
    }

    private void generateRpcRegisterFile(YangNode curNode) throws IOException {
        JavaImportData importData = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getRpcFragmentFiles().getJavaImportData();
        for (YangNode child = curNode.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangRpc)) continue;
            JavaQualifiedTypeInfoTranslator cmdImport = new JavaQualifiedTypeInfoTranslator();
            cmdImport.setForInterface(false);
            cmdImport.setPkgInfo(child.getJavaPackage());
            cmdImport.setClassInfo(YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(child.getJavaClassNameOrBuiltInType(), null)) + "Command");
            importData.addImportInfo(cmdImport, "RegisterRpc", curNode.getJavaPackage());
        }
        List<String> imports = importData.getImports(false);
        imports.add(importData.getImportForLinkedList());
        imports.add(importData.getImportForList());
        imports.add(importData.getImportForRpcCommand());
        imports.add(importData.getImportForRpcHandler());
        imports.add(importData.getImportForDynamicStoreService());
        imports.add(importData.getImportForModelConverter());
        this.rpcRegisterFileHandler = this.getJavaFileHandle("RegisterRpc");
        JavaFileGenerator.generateRegisterRpc(this.rpcRegisterFileHandler, curNode, imports);
    }

    @Override
    public void freeTemporaryResources(boolean errorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.rpcHandlerFileHandler, errorOccurred);
        FileSystemUtil.closeFile(this.rpcExtendedCommandFileHandler, errorOccurred);
        FileSystemUtil.closeFile(this.rpcRegisterFileHandler, errorOccurred);
        super.freeTemporaryResources(errorOccurred);
    }

    public static String getRpcHandlerContents() {
        StringBuilder builder = new StringBuilder("\n");
        builder.append("    ").append("private").append(" ").append("ExecutorService").append(" ").append(VAR_EXECUTOR).append(";").append("\n").append(TempJavaRpcFragmentFiles.getExecuteRpcMethod()).append(TempJavaRpcFragmentFiles.getRpcExecuterClass());
        return builder.toString();
    }

    public static String getRpcExtendedCommandContents() {
        StringBuilder builder = new StringBuilder("\n").append(JavaDocGen.getJavaDocForRpcExtendedCommandConstructor()).append("\n").append("    ").append("public").append(" ").append("RpcExtendedCommand").append("(").append("ResourceId").append(" ").append(VAR_CMD_ID).append(")").append(" ").append("{").append("\n").append("        ").append("super").append("(").append(VAR_CMD_ID).append(")").append(";").append("\n").append("    ").append("}").append("\n").append("\n").append(JavaDocGen.getJavaDocForExtendedExecuteMethod()).append("\n").append("    ").append("public").append(" ").append("abstract").append(" ").append("void").append(" ").append(EXECUTE).append("(").append("RpcInput").append(" ").append(VAR_RPC_INPUT).append(",").append(" ").append("int").append(" ").append(VAR_MSG_ID).append(")").append(";").append("\n");
        return builder.toString();
    }

    public static String getRegisterRpcContents(YangNode node) {
        StringBuilder builder = new StringBuilder("\n");
        String appService = YangIoUtils.getCamelCase(node.getJavaClassNameOrBuiltInType(), null) + "Service";
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(VAR_CFG_SERVICE, "YangRpcService");
        param.put(VAR_MODEL_CONVERTER, "ModelConverter");
        param.put(VAR_APP_SERVICE, YangIoUtils.getCapitalCase(appService));
        builder.append(StringGenerator.getVariableDeclaration(VAR_RPC_COMMANDS, "List<RpcCommand>", "    ", "private", null)).append(StringGenerator.getVariableDeclaration(VAR_RPC_HANDLER, "RpcHandler", "    ", "private", null)).append(StringGenerator.getVariableDeclaration(VAR_CFG_SERVICE, "YangRpcService", "    ", "private", null)).append(StringGenerator.getVariableDeclaration(VAR_MODEL_CONVERTER, "ModelConverter", "    ", "private", null)).append(StringGenerator.getVariableDeclaration(VAR_APP_SERVICE, YangIoUtils.getCapitalCase(appService), "    ", "private", null)).append("\n").append(JavaDocGen.getJavadocForRegisterRpcConstructor()).append("\n").append(StringGenerator.multiAttrMethodSignature("RegisterRpc", null, "public", null, param, MethodClassTypes.CLASS_TYPE, "    ")).append(StringGenerator.valueAssign("this.rpcCommands", "new LinkedList<RpcCommand>()", "        ")).append(StringGenerator.valueAssign("this.rpcHandler", "new DefaultRpcHandler()", "        ")).append(StringGenerator.valueAssign("this.cfgService", VAR_CFG_SERVICE, "        ")).append(StringGenerator.valueAssign("this.modelConverter", VAR_MODEL_CONVERTER, "        ")).append(StringGenerator.valueAssign("this.appService", VAR_APP_SERVICE, "        ")).append("    ").append("}").append("\n").append(TempJavaRpcFragmentFiles.getRegisterRpcMethod()).append(TempJavaRpcFragmentFiles.getCreateRpcCommandMethod(node));
        return builder.toString();
    }

    private static String getExecuteRpcMethod() {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(VAR_MSG_ID, "Integer");
        param.put(VAR_CMD, "RpcCommand");
        param.put(VAR_INPUT, "RpcInput");
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add(VAR_MSG_ID);
        parameters.add("(RpcExtendedCommand) cmd");
        parameters.add(VAR_INPUT);
        StringBuilder builder = new StringBuilder(StringGenerator.getOverRideString());
        builder.append(StringGenerator.multiAttrMethodSignature(EXECUTE_RPC, null, "public", "void", param, MethodClassTypes.CLASS_TYPE, "    ")).append(StringGenerator.valueAssign(VAR_EXECUTOR, "Executors.newSingleThreadExecutor()", "        ")).append("        ").append(VAR_EXECUTOR).append(".").append(EXECUTE).append("(").append(StringGenerator.createNewInstance("RpcExecuter", "", parameters)).append(")").append(";").append("\n").append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    public static String getRpcExecuterClass() {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put(VAR_MSG_ID, "Integer");
        param.put(VAR_CMD, "RpcExtendedCommand");
        param.put(VAR_INPUT, "RpcInput");
        StringBuilder builder = new StringBuilder();
        builder.append(JavaDocGen.getJavaDocWithoutParam("    * Runnable capable of invoking the appropriate RPC command's execute method", "    ")).append("    ").append(StringGenerator.getDefaultDefinitionWithImpl("class", "RpcExecuter", "public", "Runnable")).append(StringGenerator.getVariableDeclaration(VAR_MSG_ID, "Integer", "        ", null, null)).append(StringGenerator.getVariableDeclaration(VAR_CMD, "RpcExtendedCommand", "        ", null, null)).append(StringGenerator.getVariableDeclaration(VAR_INPUT, "RpcInput", "        ", null, null)).append(JavaDocGen.getJavaDocForRpcExecuterConstructor()).append("\n").append(MethodsGenerator.getParaMeterisiedConstructor("RpcExecuter", "public", param, "        ")).append("\n").append(TempJavaRpcFragmentFiles.getRunMethod()).append(StringGenerator.methodClose(IndentationType.FOUR_SPACE));
        return builder.toString();
    }

    private static String getRunMethod() {
        StringBuilder builder = new StringBuilder();
        builder.append("        ").append("@Override").append("\n").append("        ").append("public").append(" ").append("void").append(" ").append("run").append("(").append(")").append(" ").append("{").append("\n").append("            ").append(VAR_CMD).append(".").append(EXECUTE).append("(").append(VAR_INPUT).append(",").append(" ").append(VAR_MSG_ID).append(")").append(";").append("\n").append("        ").append("}").append("\n");
        return builder.toString();
    }

    private static String getRegisterRpcMethod() {
        StringBuilder builder = new StringBuilder();
        builder.append(JavaDocGen.getJavaDocWithoutParam("    * Registers RPC handler with dynamic config service", "    ")).append("    ").append("public").append(" ").append("void").append(" ").append(REGISTER_RPC_METHOD).append("(").append(")").append(" ").append("{").append("\n").append("        ").append(CREATE_RPC_CMDS).append("(").append(")").append(";").append("\n").append(StringGenerator.getForLoopString("        ", "RpcCommand", VAR_RPC_COMMAND, VAR_RPC_COMMANDS)).append("            ").append(VAR_CFG_SERVICE).append(".").append(REGISTER_HANDLER).append("(").append(VAR_RPC_HANDLER).append(",").append(" ").append(VAR_RPC_COMMAND).append(")").append(";").append("\n").append("        ").append("}").append("\n").append("    ").append("}").append("\n");
        return builder.toString();
    }

    private static String getCreateRpcCommandMethod(YangNode node) {
        StringBuilder builder = new StringBuilder();
        builder.append(JavaDocGen.getJavaDocWithoutParam("    * Creates RPC command for all the RPC", "    ")).append("    ").append("public").append(" ").append("void").append(" ").append(CREATE_RPC_CMDS).append("(").append(")").append(" ").append("{").append("\n").append(TempJavaRpcFragmentFiles.getCreateRpcCmdContents(node)).append("    ").append("}").append("\n");
        return builder.toString();
    }

    private static String getCreateRpcCmdContents(YangNode node) {
        StringBuilder builder = new StringBuilder();
        for (YangNode child = node.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangRpc)) continue;
            builder.append(TempJavaRpcFragmentFiles.getCreateRpcCommand(child));
        }
        return builder.toString();
    }

    public static String getCreateRpcCommand(YangNode node) {
        StringBuilder builder = new StringBuilder();
        String cmdName = YangIoUtils.getSmallCase(node.getJavaClassNameOrBuiltInType());
        builder.append("        ").append("RpcCommand").append(" ").append(cmdName).append(" ").append("=").append(" ").append("new").append(" ").append(YangIoUtils.getCapitalCase(node.getJavaClassNameOrBuiltInType())).append("Command").append("(").append(VAR_CFG_SERVICE).append(",").append(" ").append(VAR_MODEL_CONVERTER).append(",").append(" ").append(VAR_APP_SERVICE).append(")").append(";").append("\n").append("        ").append(VAR_RPC_COMMANDS).append(".").append("add").append("(").append(cmdName).append(")").append(";").append("\n");
        return builder.toString();
    }
}

