/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.runtime.Annotation;
import org.onosproject.yang.runtime.RuntimeContext;

public class DefaultRuntimeContext
implements RuntimeContext {
    private String dataFormat;
    private List<Annotation> annotations;

    protected DefaultRuntimeContext(Builder b) {
        this.dataFormat = b.dataFormat;
        this.annotations = b.annotations;
    }

    @Override
    public String getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public List<Annotation> getProtocolAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        return Objects.hash(this.dataFormat, this.annotations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRuntimeContext) {
            DefaultRuntimeContext that = (DefaultRuntimeContext)obj;
            return Objects.equals(this.dataFormat, that.dataFormat) && Objects.equals(this.annotations, that.annotations);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("dataFormat", (Object)this.dataFormat).add("annotations", this.annotations).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements RuntimeContext.Builder {
        private String dataFormat;
        private List<Annotation> annotations = new LinkedList<Annotation>();

        @Override
        public RuntimeContext.Builder setDataFormat(String df) {
            this.dataFormat = df;
            return this;
        }

        @Override
        public RuntimeContext.Builder addAnnotation(Annotation a) {
            this.annotations.add(a);
            return this;
        }

        @Override
        public RuntimeContext build() {
            return new DefaultRuntimeContext(this);
        }
    }
}

